use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use qbit;
use Test::More;
use Test::Deep qw(cmp_deeply);
use Test::Exception;

use PiConstants qw( $EARTH_REGION_ID );

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            $app->api_geobase->get_region_parents_by_ip('95.108.173.74'),
            [
                213,      # Moscow
                1,        # Moscow and Moscow region
                3,        # Central
                225,      # Russia
                10001,    # Eurasia
                $EARTH_REGION_ID,
            ],
            'get_region_parents_by_ip()'
        );

        is($app->api_geobase->get_region_by_ip('95.108.172.48')->{'id'}, 213, 'get_region_by_ip()');
    },
    mock_http => 0,
);
