use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use qbit;
use Test::More skip_all => 'Need to fix bk';

run_tests(
    sub {
        my ($app) = @_;

        my $dsp_id = 2317558;

        $app->api_http_bk->edit_dsp(
            $dsp_id,
            show_probability => 44,
            short_caption    => 'sample',
        );
        my $data_1 = $app->api_http_bk->get_dsp_info($dsp_id);

        is($data_1->[0]{ShowProbability}, '44.000000', 'ShowProbability is correct');
        is($data_1->[0]{Caption},         'sample',    'Caption is correct');

        {
            no strict 'refs';
            no warnings 'redefine';
            local *{'QBit::Application::Model::API::HTTP::get'} = sub {
                my ($self, $uri, %params) = @_;

                my ($uri_part) = $uri =~ /(caption=.*?)&/;

                is(
                    $uri_part,
                    'caption=%D0%9F%D1%80%D0%BE%D0%B2%D0%B5%D1%80%D0%BA%D0%B0%20%D1%80%D0%B0%D0%B1%D0%BE%D1%82%D1%8B',
                    'caption is encoded correctly',
                  );

                return '{"code":0}';
            };

            $app->api_http_bk->edit_dsp($dsp_id, short_caption => 'Проверка работы',);
        }

        my $new_text = 'Тест ' . time();

        $app->api_http_bk->edit_dsp(
            $dsp_id,
            show_probability => 65,
            short_caption    => $new_text,
        );
        my $data_2 = $app->api_http_bk->get_dsp_info($dsp_id);

        is($data_2->[0]{ShowProbability}, '65.000000', 'ShowProbability is correct');
        is($data_2->[0]{Caption},         $new_text,   'Caption is correct');

    },
    mock_http => 0,
);
