use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More skip_all => 'this test should be converted to monitoring';

use lib::abs;
use qbit;
use Socket;
use URI;

sub get_urls_from_config {

    my @urls;

    my $file_name = lib::abs::path('../configs/dev/Application.json');
    my %config    = do $file_name;

    foreach my $model (sort keys %config) {
        next if ref $config{$model} ne 'HASH';
        foreach my $name (sort keys %{$config{$model}}) {
            if ($name =~ /^url$/i) {
                push @urls, $config{$model}->{$name};
            }
        }
    }

    return @urls;
}

=begin comment

Код проверки подключения утащен из модуля https://metacpan.org/pod/Test::RequiresInternet

=end comment

=cut

sub can_connect {
    my ($host, $port) = @_;

    eval {
        # http://stackoverflow.com/questions/3570440/perl-how-to-get-iosocketinet-timeout-after-x-seconds
        local $SIG{ALRM} = sub {die 'Timed Out';};
        alarm 1;
        my $iaddr = inet_aton($host) or die "no host: $host\n";

        my $paddr = sockaddr_in($port, $iaddr);
        my $proto = getprotobyname("tcp");

        socket(my $sock, PF_INET, SOCK_STREAM, $proto) or die "socket: $!\n";
        connect($sock, $paddr) or die "connect: $!\n";
        close($sock) or die "close: $!\n";
        alarm 0;
    };
    alarm 0;

    return $@ ? 0 : 1;
}

sub main_in_test {

    my @urls_from_config = get_urls_from_config();
    my @additional_urls  = qw(
      http://registry.ape.yandex.net
      http://partnerdb-mysql-test.yandex.ru:3378
      https://st-api.test.yandex-team.ru
      https://github.yandex-team.ru
      );

    my @urls_to_skip = qw(
      http://mfas001.yandex.ru:5000/
      https://calypso-test21.test.yamoney.ru:8094/gates/httpsbindYandex
      http://webmaster-view.graymantle.yandex.ru/
      );

    foreach my $url (@urls_from_config, @additional_urls) {
        next if grep {$_ eq $url} @urls_to_skip;
        my $uri = URI->new($url);
        ok(can_connect($uri->host, $uri->port), $url);
    }

    done_testing();

}
main_in_test();
