use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;

use lib::abs qw(
  ../lib
  );
use qbit;

use Application;

use PiSecrets qw(get_secret);

$ENV{'LAZY_LOAD'} = FALSE;

my %IGNORE_MODELS = map {$_ => TRUE} qw(models_soap_api);

my %IGNORE_FIELDS = (
    users              => [qw(contracts active_contract)],
    statistics_reports => [qw(use_as_widget)],
);

my %UNIQ = ();

my $MODEL = $ARGV[0];

main();

sub main {
    my $app = Application->new();

    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::Model::DB::_log_sql'} = sub {
            my ($self, $sql, $params) = @_;

            $sql =~ s/WHERE.*$//msi;

            my @refs;
            @refs = grep($_ && $_->[0] && $_->[0] =~ /^Application::Model::Product::/, map([caller($_)], 1 .. 10));

            $UNIQ{$sql} //= {cnt => 0, refs => ['?', '?', '?']};
            $UNIQ{$sql}->{cnt}++;
            $UNIQ{$sql}->{refs} = $refs[0] if @refs;
        };
    }

    my $config_path = $app->get_option('ApplicationPath') . 'configs/test/DatabaseConfig.json';
    my $opts        = from_json(readfile($config_path));

    $app->set_option(
        partner_db => {
            %{$opts->{'partnerdb2'}},
            database => 'partner',
            password => $ENV{SECRET_CONNECTION_TO_PARTNER2_TESTING_DATABASE}
              // get_secret('connection-to-partner2-testing-database')->{'password'},
        }
    );

    $app->partner_db->close_dbh();

    $app->set_cur_user({id => 198506264});    #yndx.blizzard
    my $tmp_rights = $app->add_all_tmp_rights();

    my @models = get_models($app);

    foreach (@models) {
        next if $IGNORE_MODELS{$_};

        next if $MODEL && $_ ne $MODEL;

        check_model($app, $_, ignore => $IGNORE_FIELDS{$_});
    }

    done_testing();
}

sub get_models {
    my ($self) = @_;

    return grep {
             blessed($self->{$_})
          && $self->{$_}->isa('QBit::Application::Model::DBManager')
          && $self->{$_}->can('get_all')
          && $self->{$_}->can('query')
          && $self->{$_}->can('query') ne \&{"QBit::Application::Model::DBManager::query"}
          && (!$ARGV[0] || $ARGV[0] eq $_)
    } keys(%$self);
}

sub check_model {
    my ($self, $model, %opts) = @_;

    my $model_fields = $self->$model->get_model_fields();

    my @fields = keys(%$model_fields);

    if (@{$opts{'ignore'} // []}) {
        my %fields_h = map {$_ => TRUE} @{$opts{'ignore'}};
        @fields = grep {!$fields_h{$_}} @fields;
    }

    my @tests = (\@fields);

    foreach (@fields) {
        push(@tests, [$_])
          if exists($model_fields->{$_}{'depends_on'}) || exists($model_fields->{$_}{'forced_depends_on'});
    }

    my $count = 0;
    foreach my $f (@tests) {
        my $test_name = "$model - " . (++$count == 1 ? 'all fields' : "$f->[0]") . ", test: $count";

        my $data;
        my $error;
        try {
            $data = $self->$model->get_all(fields => $f, limit => 100);
        }
        catch {
            note(shift->message());
            $error = TRUE;
            %UNIQ  = ();
        };

        next if $error;

        my @many_requests = grep {$UNIQ{$_}->{cnt} > 1} keys(%UNIQ);

        if (@many_requests) {
            fail($test_name);
            foreach (@many_requests) {
                note("COUNT: $UNIQ{$_}->{cnt}\nAT: $UNIQ{$_}->{refs}->[0] LINE: $UNIQ{$_}->{refs}->[2]\n$_\n");
            }
        } else {
            pass($test_name);
        }

        %UNIQ = ();
    }
}
