use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::Exception;
use Test::More;
use PiSecrets;
use Yandex::StarTrek;

my $OAUTH_TOKEN = $ENV{SECRET_STARTREK_TOKEN} // get_secret('startrek-token');

SKIP: {
    skip
"В 99% случаях забываем выставлять - лишняя работа, которая всех раздражает";
    main_in_test();
}

done_testing();

sub get_ticket {
    my ($ticket) = @_;
    my $ys = Yandex::StarTrek->new(
        oauth_token => $OAUTH_TOKEN,
        retry       => 3,
        delay       => 3,
    );
    return $ys->get_issue($ticket);
}

sub git_get_current_branch {
    my $current_branch = qx(git rev-parse --abbrev-ref HEAD);
    chomp $current_branch;
    return $current_branch;
}

sub main_in_test {
    my $current_branch = git_get_current_branch();
    if ($current_branch =~ /^(?<id>\w{2,}-\d+)_/) {
        my $id = $+{id};
        my $ticket;
        plan tests => 3;
        if (lives_ok(sub {$ticket = get_ticket($id)}, "Ticket $id exists in tracker")) {
            if (ok(exists($ticket->{'hasRelatedTicket'}), "$id Has Related Ticket: field existance")) {
                isnt($ticket->{'hasRelatedTicket'}, 'Не определено', "$id Has Related Ticket: defined");
            }
        }
    } else {
        plan skip_all => "Can't detect ticket from git branch name $current_branch.";
    }
}
