#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

use qbit;
use Application;
use Test::More;
use Test::Partner2::Mock qw(mock_subs);

use PiSecrets qw(get_secret);

# global vars
my @CHECKS;

my %LEVELS = map {$_ => 1} qw(dsp);

# subs
sub generate_checks {
    my ($app) = @_;

    $app->statistics_dsp;
    mock_subs(
        {
            'Application::Model::Statistics::MobileMediation::is_available' => sub {TRUE},
            'Application::Model::Statistics::Product::is_available'         => sub {TRUE},
        }
    );

    my $tree = $app->statistics->get_tree();

    foreach my $element (@$tree) {
        parse_tree($element);
    }
}

sub parse_tree {
    my ($hash) = @_;

    push @CHECKS,
      {
        level_id => $hash->{id},
        fields   => [map {$_->{id}} @{$hash->{fields}}],
      };

    if ($hash->{children}) {
        foreach my $element (@{$hash->{children}}) {
            parse_tree($element);
        }
    }

    return 1;
}

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $config_path = $app->get_option('ApplicationPath') . 'configs/test/DatabaseConfig.json';
    my $opts        = from_json(readfile($config_path));

    $app->set_option(
        partner_db => {
            %{$opts->{'partnerdb2'}},
            database => 'partner',
            password => $ENV{SECRET_CONNECTION_TO_PARTNER2_TESTING_DATABASE}
              // get_secret('connection-to-partner2-testing-database')->{'password'},
        }
    );

    $app->partner_db->close_dbh();

    # 155664066 = yndx-zurom
    my $yndx_user_id_with_dev_role = 155664066;
    $app->{'__CURRENT_USER_RIGHTS__'} = {};
    $app->set_cur_user({id => $yndx_user_id_with_dev_role});

    generate_checks($app);

    my $date = date_sub(curdate(), day => 5, oformat => 'db');

    foreach my $check (@CHECKS) {
        next unless $LEVELS{$check->{'level_id'}};

        eval {
            my $data = $app->statistics->get_statistics(
                period => [$date, $date],
                levels           => [{id => $check->{level_id}}],
                fields           => $check->{fields},
                entity_fields    => undef,
                dimension_fields => undef,
                dimension_filter => undef,
                vat              => -1,
                order_by         => [],
                total            => 0,
            );
        };

        ok(!$@, $check->{level_id});
    }

    $app->post_run();
    done_testing();
}
main();
__END__
