use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use qbit;
use Test::More tests => 5;
use File::Slurp qw(read_file write_file);
use File::Temp qw(tempdir);

run_tests(
    sub {
        my ($app) = @_;

        my $dir       = tempdir(UNLINK => 1);
        my $filename  = "$dir/_s3_mds_test_file";
        my $filename2 = "$dir/_s3_mds_test_file_got";
        write_file($filename, '_s3_mds_test_content');

        my $list = $app->api_media_storage_s3->list();
        ok(!(grep {$_ eq $filename} @$list), 'list before put');

        $app->api_media_storage_s3->put_file($filename, 'application/octet-stream', $filename);
        sleep 2;
        $list = $app->api_media_storage_s3->list();
        ok((grep {$_ eq $filename} @$list), 'list after put');

        $app->api_media_storage_s3->get_file($filename, $filename2);
        is(read_file($filename2), read_file($filename), 'get and compare');

        $app->api_media_storage_s3->delete($filename);
        sleep 2;
        $list = $app->api_media_storage_s3->list();
        ok(!(grep {$_ eq $filename} @$list), 'list after delete');
    },
    dont_create_database => 1,
    mock_http            => 0,
    mock_time            => 0,
);
