use strict;
use warnings FATAL => 'all';

use Test::More;
use HTTP::Tiny;
use JSON::PP;

use Carp;
use Test::Partner2::Simple;
require Application::Model::Statistics::Product;

sub main_in_test {
    pass('Loaded ok');

    # Через некоторое время фронтенд уберет этот файл из своего репозитория.
    # После этого этот нужно будет убрать скачивание этого файла и использование его
    # данных в тесте (а то что отстанется от теста нужно будет переместить из t_external/ в t/)
    my $frontend_data = decode_json(
        HTTP::Tiny->new()->get(
'https://a.yandex-team.ru/api/v1/repos/arc_vcs/tree/blob/adv/frontend/services/yharnam/server/models/statistics/measuresUnits.json?commit_id=trunk'
          )->{'content'}
    );

    foreach my $key (keys(%Application::Model::Statistics::Product::FIELD_TYPES)) {
        my $unit = $Application::Model::Statistics::Product::FIELD_TYPES{$key}->{'unit'};
        if ($unit) {
            pass("'$key' has unit");
            if ($frontend_data->{$key}) {
                if ($unit ne $frontend_data->{$key}) {
                    is($unit, $frontend_data->{$key}, "'$key' partner2 repo has the same unit as yharnam repo");
                }
            }
        } else {
            fail("'$key' has unit");
        }
    }

    done_testing();
}
main_in_test();
