#!/usr/bin/perl -w

use qbit;

use Test::More;

use Net::INET6Glue::INET_is_INET6;
use Yandex::Tanker;
use JSON qw();
use FindBin qw($Bin);

my @msgids_to_ignore = (
    'Answers to all questions about the partnership are in <a href=\"%s\">help<a>.',
    'Become a partner',
    'Deleted+++MSGCTXT+++:Application status',
    'Sign in for partners',
    'Yandex partners',
    'partner',
    'PartnerLogo',
    'Добро пожаловать в партнёрский интерфейс РСЯ',
    'You cannot delete working page. First stopped it',
);

my %msgids_to_ignore = map {$_ => TRUE} @msgids_to_ignore;

SKIP: {

    my $branch = 'master';
    diag "Checking branch '$branch'\n";

    my $tanker = Yandex::Tanker->new(
        {
            project => "pi2",
            url     => "https://tanker-api.yandex-team.ru",
        }
    );

    skip("no such branch '" . $branch . "' in tanker.", 4)
      unless (grep {$branch eq $_} $tanker->get_branches());

    my $tanker_data = JSON::from_json(
        $tanker->get_project_tjson(
            status => 'approved',
            branch => $branch,
        ),
        {utf8 => TRUE}
    );
    $tanker_data->{export_info}->{branch} eq $branch || die('The branch gotten from tanker is right.');

    my @problem_keys = grep {
             $_->{'translations'}
          && $_->{'translations'}->{'ru'}
          && $_->{'translations'}->{'ru'}->{'form'}
          && $_->{'translations'}->{'ru'}->{'form'} =~ /ё/
      }
      grep {
        !exists($msgids_to_ignore{$_->{'msgid'}});
      }
      map {
        extract_keys($_)
      }
      map {
        $_->{keys}
      } values %{$tanker_data->{keysets}};

    if (@problem_keys) {
        foreach my $key (@problem_keys) {
            ok(FALSE, "Msgid: '$key->{'msgid'}' has prohibited YO letter");
        }
    } else {
        ok(TRUE, 'No YO letter in prohibited msgids.');
    }
}

done_testing();
exit;

sub extract_keys {
    my $hash = shift;

    my @hashes = ();
    while (my ($key, $value) = each(%$hash)) {
        push @hashes,
          {
            msgid        => $key,
            info         => $value->{'info'},
            translations => $value->{'translations'},
          };
    }
    return @hashes;
}
