package Mock::Subs;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::More;

my %original;

sub new {
    my ($class, %opts) = @_;

    $class ||= __PACKAGE__;
    my $self = \%opts;
    $self->{'original'} = \%original;

    return bless $self, $class;
}

sub _get_full_sub_name {
    my ($self, $sub_name, $package) = @_;

    $package ||= 'main';
    $sub_name = $package . '::' . $sub_name
      unless ($sub_name =~ /::/);

    return $sub_name;
}

sub mock {
    my ($self, $sub_name, %opts) = @_;

    $sub_name = $self->_get_full_sub_name($sub_name, scalar(caller()));
    $self->{'original'}{$sub_name} = \&$sub_name
      unless ($self->{'original'}{$sub_name});    # Запомним оригинальную сабу

    my $sub = sub {
        pass($opts{'test_pass'}) if ($opts{'test_pass'});
        fail($opts{'test_fail'}) if ($opts{'test_fail'});
        die $opts{'fatal'}       if $opts{'fatal'};

        return ($opts{'return'} ? $opts{'return'} : ());
    };

    {
        no strict 'refs';
        no warnings 'redefine';

        *$sub_name = $sub;
    }

    $self->{'mocked'}{$sub_name} = $sub;

    return $self;
}

sub unmock {
    my ($self, $sub_name) = @_;

    $sub_name = $self->_get_full_sub_name($sub_name, scalar(caller()));

    if ($self->{'mocked'}{$sub_name}) {
        $self->{'unmocked'}{$sub_name} = delete $self->{'mocked'}{$sub_name};

        if (defined $self->{'original'}{$sub_name}) {
            no strict 'refs';
            no warnings 'redefine';

            *$sub_name = $self->{'original'}{$sub_name};
        } else {
            no strict 'refs';
            no warnings 'redefine';

            undef &$sub_name;
        }
    }

    return $self;
}

sub DESTROY {
    my ($self) = @_;

    $self->unmock($_) foreach (keys %{$self->{'mocked'}});
}

1;
