package Test::Partner2::Fixture;

use qbit;

use Test::Partner2::Fixture::DB::Block;
use Test::Partner2::Fixture::DB::DSP;
use Test::Partner2::Fixture::DB::Page;
use Test::Partner2::Fixture::DB::Source;
use Test::Partner2::Fixture::DB::StatReportParamsDigest;
use Test::Partner2::Fixture::DB::Dict;
use Test::Partner2::Fixture::DB::User;
use Test::Partner2::Fixture::DB::UserFeatures;
use Test::Partner2::Fixture::DB;
use Test::Partner2::Mock;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(get_fixture get_fixtures get_fixtures_hash);
our @EXPORT    = @EXPORT_OK;

my %fixtures = (
    Test::Partner2::Fixture::DB::Block::get_fixtures(),
    Test::Partner2::Fixture::DB::DSP::get_fixtures(),
    Test::Partner2::Fixture::DB::Page::get_fixtures(),
    Test::Partner2::Fixture::DB::Source::get_fixtures(),
    Test::Partner2::Fixture::DB::StatReportParamsDigest::get_fixtures(),
    Test::Partner2::Fixture::DB::Dict::get_fixtures(),
    Test::Partner2::Fixture::DB::User::get_fixtures(),
    Test::Partner2::Fixture::DB::UserFeatures::get_fixtures(),
    Test::Partner2::Fixture::DB::get_fixtures(),
);

my %cache;

sub set_app {
    my ($app) = @_;
    mock_format_system($app);
    $fixtures{app} = {
        sub => sub {
            $app
        },
    };
}

sub load_fixture {
    my ($name) = @_;

    return $cache{$name}{value} if exists($cache{$name});

    my $fixture = $fixtures{$name};

    throw Exception "Fixture '$name' does not exist or has invalid spec"
      unless ref($fixture) eq 'HASH' && grep {exists($fixture->{$_})} (qw(deps sub));

    my @validate_models;
    for my $dependency (@{$fixture->{deps} // []}) {
        throw Exception "undef dependency for fixture $name" unless defined($dependency);
        load_fixture($dependency);
        push @validate_models, $cache{$dependency}{validate_models};
    }

    unless (exists($cache{$name})) {
        $cache{$name}{value} = $fixture->{sub}->(map {$_ => get_fixture($_)} @{$fixture->{deps}});
        $cache{$name}{validate_models} = array_uniq(@validate_models, @{$fixtures{$name}{validate_models} // []});
    }

    for my $next (@{$fixture->{next} // []}) {
        load_fixture($next);
    }

    return $cache{$name}{value};
}

sub get_fixture {
    my ($name) = @_;

    throw Exception "Fixture $name isn't loaded" unless exists($cache{$name});

    return $cache{$name}{value};
}

sub get_fixtures {
    my (@names) = @_;
    return map {get_fixture($_)} @names;
}

sub get_fixtures_hash {
    my (@names) = @_;
    return {map {$_ => get_fixture($_)} @names};
}

sub validate_models_for_fixture {
    my ($name) = @_;

    throw Exception "Fixture $name isn't loaded" unless exists($cache{$name});

    return $cache{$name}{validate_models};
}

sub dump_cache {
    my %copy = %cache;
    delete $copy{app};
    delete $copy{partner_db};
    ldump(\%copy);
}

sub add_fixtures {
    my ($list_fixtures) = @_;
    my @list;
    for my $name (sort keys %$list_fixtures) {
        $fixtures{$name} = $list_fixtures->{$name};
        push @list, $name;
    }
    return @list;
}

1;
