package Test::Partner2::Fixture::DB::Block;

use strict;
use warnings FATAL => 'all';

use QBit::StringUtils;
use Test::Partner2::Fixture::DB::Utils;

use Utils::UniqueID qw(make_unique_id);

use PiConstants qw($DEFAULT_DESIGN_TYPE);

sub get_fixtures {
    id_provider_fixture('block_id_provider'), context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block',

        page_fixture_name => 'partner_context_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_wrong_dsp_blocks',

        dsp_blocks        => [],
        page_fixture_name => 'partner_context_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_article',

        page_fixture_name => 'partner_context_page',
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_brands',

        page_fixture_name => 'partner_context_page',
        brands            => [{bid => 420, blocked => 0, cpm => 100}],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_geo',

        page_fixture_name => 'partner_context_page',
        geo               => '[{"id":"111","cpm":9999},{"id":"225","cpm":10}]',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_blocked_brands',

        page_fixture_name => 'partner_context_page',
        brands            => [{bid => 420, blocked => 1}],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_vip_block',

        page_fixture_name => 'partner_context_vip_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_mincpm_strategy',

        page_fixture_name => 'partner_context_page',

        strategy => 0,
        mincpm   => 20,
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_max_revenue_strategy',

        page_fixture_name => 'partner_context_page',

        strategy => 1,
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_unmoderated_dsp',

        page_fixture_name => 'partner_context_page_with_unmoderated_rtb_auction',

        dsp_fixtures             => [qw(dsp_nonmoder)],
        dsp_unmoderated_fixtures => [qw(dsp_nonmoder)],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_separate_cpm_strategy',

        page_fixture_name => 'partner_context_page',

        strategy      => 3,
        text_cpm      => 10,
        text_active   => 1,
        text_blocked  => 0,
        media_cpm     => undef,
        media_active  => 1,
        media_blocked => 1,
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_video_design',

        page_fixture_name => 'partner_context_page_with_video',

        show_video       => 1,
        design_templates => [
            {
                caption         => 'video design',
                type            => 'video',
                design_settings => {name => 'inpage',},
            },
        ],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_separate_cpm_strategy_and_video_cpm',

        page_fixture_name => 'partner_context_page_with_video',

        show_video       => 1,
        design_templates => [
            {
                caption         => 'video design',
                type            => 'video',
                design_settings => {name => 'inpage',},
            },
        ],

        strategy      => 3,
        text_cpm      => 10,
        text_active   => 1,
        text_blocked  => 0,
        media_cpm     => undef,
        media_active  => 1,
        media_blocked => 1,
        video_cpm     => 666,
        video_active  => 1,
        video_blocked => 0,
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_native_design',

        page_fixture_name => 'partner_context_page',

        design_templates => [
            {
                caption         => 'native design',
                type            => 'native',
                design_settings => {
                    "css"          => ".css{color:red;}",
                    "grid_columns" => 1,
                    "grid_rows"    => 3,
                    "template"     => "<div class='css'>ads with \${grid_columns} and \${grid_rows}</div>"
                },
            },
        ],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_mobile_with_design_templates',

        page_fixture_name => 'partner_context_page',

        site_version     => "mobile",
        design_templates => [
            {
                caption                 => "design template 240x400",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 0,
                design_settings         => {
                    "name"               => "240x400",
                    "limit"              => 1,
                    "bgColor"            => "FFFFFF",
                    "blockId"            => "R-A-1-24",
                    "favicon"            => JSON::XS::true,
                    "urlColor"           => "006600",
                    "textColor"          => "000000",
                    "borderType"         => "block",
                    "hoverColor"         => "DD0000",
                    "titleColor"         => "3263A5",
                    "borderColor"        => "DDDCDA",
                    "imagesFirst"        => JSON::XS::false,
                    "noSitelinks"        => JSON::XS::false,
                    "siteBgColor"        => "FFFFFF",
                    "borderRadius"       => JSON::XS::false,
                    "headerBgColor"      => "FFFFFF",
                    "linksUnderline"     => JSON::XS::true,
                    "sitelinksColor"     => "3263A5",
                    "horizontalAlign"    => JSON::XS::true,
                    "interscroller"      => JSON::XS::true,
                    "fullscreen"         => JSON::XS::true,
                    "fullscreenDuration" => 10
                },
            },
        ]
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_design_templates',

        page_fixture_name => 'partner_context_page',

        design_templates => [
            {
                caption                 => "design template 240x400",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 0,
                design_settings         => {
                    "name"               => "240x400",
                    "limit"              => 1,
                    "bgColor"            => "FFFFFF",
                    "blockId"            => "R-A-1-24",
                    "favicon"            => JSON::XS::true,
                    "urlColor"           => "006600",
                    "textColor"          => "000000",
                    "borderType"         => "block",
                    "hoverColor"         => "DD0000",
                    "titleColor"         => "3263A5",
                    "borderColor"        => "DDDCDA",
                    "imagesFirst"        => JSON::XS::false,
                    "noSitelinks"        => JSON::XS::false,
                    "siteBgColor"        => "FFFFFF",
                    "borderRadius"       => JSON::XS::false,
                    "headerBgColor"      => "FFFFFF",
                    "linksUnderline"     => JSON::XS::true,
                    "sitelinksColor"     => "3263A5",
                    "horizontalAlign"    => JSON::XS::true,
                    "interscroller"      => JSON::XS::true,
                    "fullscreen"         => JSON::XS::true,
                    "fullscreenDuration" => 10
                },
            },
            {
                caption                 => "design template",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 0,
                design_settings         => {
                    "name"            => "728x90",
                    "limit"           => undef,
                    "favicon"         => JSON::XS::true,
                    "urlColor"        => "006600",
                    "textColor"       => "000000",
                    "borderType"      => "block",
                    "hoverColor"      => "DD0000",
                    "titleColor"      => "0066CC",
                    "borderColor"     => "DDDCDA",
                    "imagesFirst"     => JSON::XS::true,
                    "noSitelinks"     => JSON::XS::false,
                    "siteBgColor"     => "FFFFFF",
                    "borderRadius"    => JSON::XS::false,
                    "adaptiveWidth"   => "",
                    "adaptiveHeight"  => "",
                    "linksUnderline"  => JSON::XS::true,
                    "sitelinksColor"  => "0066CC",
                    "horizontalAlign" => JSON::XS::true,
                },
            },
            {
                caption                 => "custom design template - adaptive0418 (unavailable format - bug)",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 1,
                design_settings         => {
                    "name"              => "adaptive0418",
                    "limit"             => "1",
                    "favicon"           => JSON::XS::true,
                    "fontSize"          => "1.1",
                    "urlColor"          => "006600",
                    "textColor"         => "000000",
                    "borderType"        => "none",
                    "fontFamily"        => "",
                    "hoverColor"        => "DD0000",
                    "titleColor"        => "0000CC",
                    "imagesFirst"       => JSON::XS::false,
                    "noSitelinks"       => JSON::XS::true,
                    "siteBgColor"       => "FFFFFF",
                    "adaptiveWidth"     => "",
                    "titleFontSize"     => "3",
                    "adaptiveHeight"    => "",
                    "linksUnderline"    => JSON::XS::true,
                    "horizontalAlign"   => JSON::XS::true,
                    "bannerDescription" => "",
                },
            },
            {
                caption                 => "custom design template - posterVertical",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 1,
                design_settings         => {
                    "name"              => "posterVertical",
                    "limit"             => "5",
                    "favicon"           => JSON::XS::true,
                    "fontSize"          => "1.1",
                    "urlColor"          => "006600",
                    "textColor"         => "000000",
                    "borderType"        => "none",
                    "fontFamily"        => "",
                    "hoverColor"        => "DD0000",
                    "titleColor"        => "0000CC",
                    "imagesFirst"       => JSON::XS::false,
                    "noSitelinks"       => JSON::XS::true,
                    "siteBgColor"       => "FFFFFF",
                    "adaptiveWidth"     => "",
                    "titleFontSize"     => "3",
                    "adaptiveHeight"    => "",
                    "linksUnderline"    => JSON::XS::true,
                    "horizontalAlign"   => JSON::XS::true,
                    "bannerDescription" => "",
                },
            },
            {
                caption                 => "custom design template - customFormat",
                type                    => $DEFAULT_DESIGN_TYPE,
                is_custom_format_direct => 1,
                design_settings         => {
                    "name"              => "customFormat",
                    "limit"             => "2",
                    "favicon"           => JSON::XS::true,
                    "fontSize"          => "1.1",
                    "urlColor"          => "006600",
                    "textColor"         => "000000",
                    "borderType"        => "none",
                    "fontFamily"        => "",
                    "hoverColor"        => "DD0000",
                    "titleColor"        => "0000CC",
                    "imagesFirst"       => JSON::XS::false,
                    "noSitelinks"       => JSON::XS::true,
                    "siteBgColor"       => "FFFFFF",
                    "adaptiveWidth"     => "",
                    "titleFontSize"     => "3",
                    "adaptiveHeight"    => "",
                    "linksUnderline"    => JSON::XS::true,
                    "horizontalAlign"   => JSON::XS::true,
                    "bannerDescription" => "",
                },
            }
        ]
      ),
      context_rtb_block_fixtures(
        fixture_name => 'adinside_context_rtb_block',

        page_fixture_name => 'adinside_context_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'business_unit_context_rtb_block',

        page_fixture_name => 'business_unit_context_page',
      ),
      internal_context_rtb_block_fixtures(
        fixture_name => 'internal_context_rtb_block',

        page_fixture_name => 'internal_context_page',
      ),
      internal_context_rtb_block_fixtures(
        fixture_name => 'internal_context_rtb_block_pvf',

        page_fixture_name => 'internal_context_page',

        show_video   => 1,
        caption      => 'pvf',
        opts         => {premium_video_format => 1},
        dsp_fixtures => [qw(dsp_direct dsp_awaps_video_auction_in_banner)],
      ),
      internal_context_rtb_block_fixtures(

        fixture_name => 'internal_context_rtb_block_wuth_only_portal_trusted_banners',

        page_fixture_name => 'internal_context_page',

        caption => 'only_portal_trusted_banners',
        opts    => {only_portal_trusted_banners => 1},
      ),
      internal_context_rtb_block_fixtures(
        fixture_name => 'internal_context_rtb_block_with_turbo_version',

        site_version => 'turbo',

        page_fixture_name => 'internal_context_page',
      ),
      internal_context_rtb_block_fixtures(
        fixture_name => 'internal_context_rtb_block_with_turbo_desktop_version',

        site_version => 'turbo_desktop',

        page_fixture_name => 'internal_context_page',
      ),
      internal_context_rtb_block_fixtures(
        fixture_name => 'internal_context_rtb_block_with_carousel',

        site_version => 'internal_context_page',

        page_fixture_name => 'internal_context_page',

        design_templates => [
            {
                caption         => 'native design',
                type            => 'native',
                design_settings => {
                    "css"          => ".css{color:red;}",
                    "grid_columns" => 1,
                    "grid_rows"    => 1,
                    "template" =>
"<div class='css'><ya-units-slider>ads with \${grid_columns} and \${grid_rows}</ya-units-slider></div>"
                },
            },
        ],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_show_video',

        page_fixture_name => 'partner_context_page',

        show_video => 1,

        dsp_fixtures => [qw(dsp_direct dsp_awaps_video_auction_in_banner)],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_show_video_and_pvf',

        page_fixture_name => 'partner_context_page',

        show_video   => 1,
        caption      => 'pvf',
        opts         => {premium_video_format => 1},
        dsp_fixtures => [qw(dsp_direct dsp_awaps_video_auction_in_banner)],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_only_portal_trusted_banners',

        page_fixture_name => 'partner_context_page',

        caption => 'only_portal_trusted_banners',
        opts    => {only_portal_trusted_banners => 1},
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_amp_version',

        site_version => 'amp',

        page_fixture_name => 'partner_context_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_turbo_version',

        site_version => 'turbo',

        page_fixture_name => 'partner_context_page',
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_turbo_desktop_version',

        site_version => 'turbo_desktop',

        page_fixture_name => 'partner_context_page',
      ),
      context_adblock_block_fixtures(
        fixture_name => 'partner_context_adblock_block',

        page_fixture_name => 'partner_context_page',
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block',

        page_fixture_name => 'partner_mobile_page',
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_custom_bk_data',

        page_fixture_name => 'partner_mobile_page',

        is_custom_bk_data => 1,
        bk_data           => '{"custom_bk_data": true}',
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_slider',

        page_fixture_name => 'partner_mobile_page',

        opts  => {show_slider => 1},
        limit => 9,
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_simple_inapp_rtb_block_with_slider',

        page_fixture_name => 'partner_mobile_page_simple_inapp',

        opts  => {show_slider => 1},
        limit => 7,
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_show_video_true',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {show_video => 1, caption => 'native with simple_inapp and show_video=1'},
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_show_video_false',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {show_video => 0, caption => 'native with simple_inapp and show_video=0'},
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_rich_media_true',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {rich_media => 1, caption => 'native with simple_inapp and rich_media=1'},
      ),
      mobile_native_rtb_block_fixtures(
        fixture_name => 'partner_mobile_native_rtb_block_with_rich_media_false',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {rich_media => 1, caption => 'native with simple_inapp and rich_media=0'},
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block',

        page_fixture_name => 'partner_mobile_page',
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block_with_show_video',

        page_fixture_name => 'partner_mobile_page',
        show_video        => 1
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block_with_rich_media_true',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {rich_media => 1},
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block_with_rich_media_false',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
        opts              => {rich_media => 0},
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block_with_mobile_mediation',

        page_fixture_name => 'partner_mobile_page',

        place_id => 555,
        opts     => {is_mobile_mediation => 1,},
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name => 'partner_mobile_banner_rtb_block_without_mobile_mediation',

        page_fixture_name => 'partner_mobile_page',

        place_id => 555,
      ),
      mobile_rewarded_rtb_block_fixtures(
        fixture_name => 'partner_mobile_rewarded_block_simple_inapp',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
      ),
      mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'partner_mobile_interstitial_block_simple_inapp',

        page_fixture_name => 'partner_mobile_page_simple_inapp',
      ),
      mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'partner_mobile_interstitial_rtb_block',

        page_fixture_name => 'partner_mobile_page',
      ),
      mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'partner_mobile_interstitial_rtb_block_with_show_video',

        page_fixture_name => 'partner_mobile_page',
        show_video        => 1
      ),
      mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'adinside_mobile_interstitial_rtb_block',

        page_fixture_name => 'adinside_mobile_page',
      ),
      mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'business_unit_mobile_interstitial_rtb_block',

        page_fixture_name => 'business_unit_mobile_page',
      ),
      mobile_rewarded_rtb_block_fixtures(
        fixture_name => 'partner_mobile_rewarded_rtb_block',

        page_fixture_name => 'partner_mobile_page',
      ),
      mobile_banner_rtb_block_fixtures(
        fixture_name      => 'partner_mobile_adaptive_banner_rtb_block',
        page_fixture_name => 'partner_mobile_page',

        caption      => 'Mocked Adaptive Banner Mobile Block',
        block_type   => 'adaptive_banner',
        direct_block => 'adaptive0418',
        media_block  => 'adaptive0418',
        dsp_blocks   => ['adaptive0418'],
        dsp_fixtures => [
            qw(
              dsp_direct
              )
        ],
      ),
      internal_mobile_banner_rtb_block_fixtures(
        fixture_name => 'internal_mobile_banner_rtb_block',

        page_fixture_name => 'internal_mobile_page',
      ),
      internal_mobile_interstitial_rtb_block_fixtures(
        fixture_name => 'internal_mobile_interstitial_rtb_block',

        page_fixture_name => 'internal_mobile_page',
      ),
      internal_mobile_interstitial_rtb_block_fixtures(
        fixture_name      => 'internal_mobile_adaptive_banner_rtb_block',
        page_fixture_name => 'internal_mobile_page',

        caption      => 'Mocked Adaptive Banner Internal Mobile Block',
        block_type   => 'adaptive_banner',
        direct_block => 'adaptive0418',
        media_block  => 'adaptive0418',
        dsp_blocks   => ['adaptive0418'],
        dsp_fixtures => [
            qw(
              dsp_direct
              )
        ],
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block',

        page_fixture_name => 'partner_video_page',
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_with_vpaid_disabled',

        page_fixture_name => 'partner_video_page_with_vpaid_disabled',
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_with_jingles',

        page_fixture_name => 'partner_video_page',
        opts              => {
            call_promo_code          => '<xml>promo</xml>',
            jingle_code_at_end       => '<xml>jingle end</xml>',
            jingle_code_at_start     => '<xml>jingle start</xml>',
            jingle_code_before_promo => '<xml>before promo</xml>'
        }
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_with_max_revenue_strategy',

        page_fixture_name => 'partner_video_page',

        caption  => 'Mocked Instream Block with Max Revenue strategy',
        strategy => 1,
        mincpm   => undef,
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_inroll',

        page_fixture_name => 'partner_video_page',

        caption           => 'Mocked Instream Block Inroll',
        type              => 6,
        repeat            => 2,
        server_side       => 0,
        broadcast_replace => 1,
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_s2sroll',

        page_fixture_name => 'partner_video_page',

        caption           => 'Mocked Instream Block S2sroll',
        type              => 7,
        repeat            => 2,
        server_side       => 1,
        try_client        => 0,
        broadcast_replace => 1,
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_overlay',

        page_fixture_name => 'partner_video_page',

        caption      => 'Mocked Instream Block Overlay',
        repeat       => 0,
        type         => 8,
        max_duration => 30,
        opts         => {
            order_tags  => [2],
            target_tags => [5]
        }
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_vmap',

        page_fixture_name => 'partner_video_page_vmap',

        caption => 'Mocked Instream Block with VMAP',
        vmap_id => 1,
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_video-non-skippable',

        video_performance_active => 1,
        video_performance_cpm    => 1,
        page_fixture_name        => 'partner_video_page',
      ),
      inpage_video_block_fixtures(
        fixture_name => 'partner_inpage_video_block',

        page_fixture_name => 'partner_video_page',
      ),
      inpage_video_block_fixtures(
        fixture_name => 'partner_inpage_video_block_w_blocked_videodirect',

        page_fixture_name => 'partner_video_page',

        strategy                  => 3,
        video_performance_active  => 1,
        video_performance_blocked => 1,
        video_performance_cpm     => undef,
        video_motion              => 1,
      ),
      fullscreen_video_block_fixtures(
        fixture_name => 'partner_fullscreen_video_block',

        page_fixture_name => 'partner_video_page',
      ),
      indoor_video_block_fixtures(
        fixture_name => 'partner_indoor_video_block',

        page_fixture_name => 'partner_indoor_page',
      ),
      indoor_video_block_fixtures(
        fixture_name => 'partner_indoor_video_block_with_custom_bk_data',

        page_fixture_name => 'partner_indoor_page',

        is_custom_bk_data => 1,
        bk_data           => '{"custom_bk_data": true}',

        opts => {
            moderation => {
                photo_id_list =>
                  {10001 => {verdict => 0, request_id => 111112}, 10002 => {verdict => 0, request_id => 111113},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [],
        }
      ),
      indoor_video_block_fixtures(
        fixture_name => 'partner_indoor_video_block_with_moderation',

        page_fixture_name => 'partner_indoor_page',

        multistate => 64,
        opts       => {
            moderation => {
                photo_id_list =>
                  {10001 => {verdict => 0, request_id => 111112}, 10002 => {verdict => 0, request_id => 111113},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [],
        }
      ),
      indoor_video_block_fixtures(
        fixture_name => 'partner_indoor_video_block_with_photos',

        page_fixture_name => 'partner_indoor_page',

        opts => {photo_id_list => [10001]},
      ),
      indoor_video_block_fixtures(
        fixture_name => 'partner_updated_indoor_video_block',

        page_fixture_name => 'partner_updated_indoor_page',
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_video_block_with_photos',

        page_fixture_name => 'partner_outdoor_page',

        opts => {photo_id_list => [10001]}

      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_video_block',

        page_fixture_name => 'partner_outdoor_page',
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_video_block_with_custom_bk_data',

        page_fixture_name => 'partner_outdoor_page',

        is_custom_bk_data => 1,
        bk_data           => '{"custom_bk_data": true}',

        opts => {
            moderation => {
                gps     => {'-11.1,66.6'                   => {verdict => 0, request_id => 111665},},
                address => {'Mocked Outdoor Block address' => {verdict => 0, request_id => 111665},},
                caption => {'Mocked Outdoor Block'         => {verdict => 0, request_id => 111666},},
                photo_id_list =>
                  {10001 => {verdict => 0, request_id => 111667}, 10002 => {verdict => 0, request_id => 111668},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [],
        }
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_video_block_with_moderation',

        page_fixture_name => 'partner_outdoor_page',

        multistate => 64,
        opts       => {
            moderation => {
                gps     => {'-11.1,66.6'                   => {verdict => 0, request_id => 111665},},
                address => {'Mocked Outdoor Block address' => {verdict => 0, request_id => 111665},},
                caption => {'Mocked Outdoor Block'         => {verdict => 0, request_id => 111666},},
                photo_id_list =>
                  {10001 => {verdict => 0, request_id => 111667}, 10002 => {verdict => 0, request_id => 111668},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [],
        }
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_block_with_moderation_for_dup_need_approve',

        page_fixture_name => 'partner_outdoor_page',

        opts => {
            moderation => {
                gps     => {'-11.1,66.6'                   => {verdict => 0,  request_id => 111665},},
                address => {'Mocked Outdoor Block address' => {verdict => 0,  request_id => 111665},},
                caption => {'Mocked Outdoor Block'         => {verdict => -1, request_id => 111666},},
                photo_id_list =>
                  {10001 => {verdict => 1, request_id => 111667}, 10002 => {verdict => 0, request_id => 111668},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [10001],
        }
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_block_with_moderation_for_dup_rejected',

        page_fixture_name => 'partner_outdoor_page',

        multistate => 256,
        opts       => {
            moderation => {
                gps     => {'-11.1,66.6'                   => {verdict => 1,  request_id => 111665},},
                address => {'Mocked Outdoor Block address' => {verdict => 1,  request_id => 111665},},
                caption => {'Mocked Outdoor Block'         => {verdict => -1, request_id => 111666},},
                photo_id_list =>
                  {10001 => {verdict => 1, request_id => 111667}, 10002 => {verdict => -1, request_id => 111668},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [10001],
        }
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_block_with_moderation_for_dup_approved',

        page_fixture_name => 'partner_outdoor_page',

        multistate => 130,
        opts       => {
            moderation => {
                gps     => {'-11.1,66.6'                   => {verdict => 1, request_id => 111665},},
                address => {'Mocked Outdoor Block address' => {verdict => 1, request_id => 111665},},
                caption => {'Mocked Outdoor Block'         => {verdict => 1, request_id => 111666},},
                photo_id_list =>
                  {10001 => {verdict => 1, request_id => 111667}, 10002 => {verdict => 1, request_id => 111668},},
            },
            photo_id_list          => [10001, 10002],
            photo_id_list_approved => [10001, 10002],
        }
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_updated_outdoor_video_block',

        page_fixture_name => 'partner_updated_outdoor_page',
      ),
      context_content_block_fixtures(
        fixture_name => 'partner_context_content_block',

        page_fixture_name => 'partner_context_page',
      ),
      context_content_block_fixtures(
        fixture_name => 'partner_context_content_block_site_version_turbo',

        page_fixture_name => 'partner_context_page',

        site_version => 'turbo',
      ),
      context_content_block_fixtures(
        fixture_name => 'partner_context_content_block_site_version_turbo_desktop',

        page_fixture_name => 'partner_context_page',

        site_version => 'turbo_desktop',
      ),
      internal_context_content_block_fixtures(
        fixture_name => 'internal_context_content_block',

        page_fixture_name => 'internal_context_page',
      ),
      internal_context_content_block_fixtures(
        fixture_name => 'internal_context_content_block_site_version_turbo',

        page_fixture_name => 'internal_context_page',

        site_version => 'turbo',
      ),
      internal_context_content_block_fixtures(
        fixture_name => 'internal_context_content_block_site_version_turbo_desktop',

        page_fixture_name => 'internal_context_page',

        site_version => 'turbo_desktop',
      ),
      context_natural_block_fixtures(
        fixture_name => 'partner_context_natural_block',

        page_fixture_name => 'partner_context_page',
      ),
      context_natural_block_fixtures(
        fixture_name => 'partner_context_natural_block_site_version_turbo',

        page_fixture_name => 'partner_context_page',

        site_version => 'turbo',
      ),
      context_natural_block_fixtures(
        fixture_name => 'partner_context_natural_block_site_version_turbo_desktop',

        page_fixture_name => 'partner_context_page',

        site_version => 'turbo_desktop',
      ),
      internal_context_natural_block_fixtures(
        fixture_name => 'internal_context_natural_block',

        page_fixture_name => 'internal_context_page',
      ),

      internal_context_natural_block_fixtures(
        fixture_name => 'internal_context_natural_block_site_version_turbo',

        page_fixture_name => 'internal_context_page',

        site_version => 'turbo',
      ),
      internal_context_natural_block_fixtures(
        fixture_name => 'internal_context_natural_block_site_version_turbo_desktop',

        page_fixture_name => 'internal_context_page',

        site_version => 'turbo_desktop',
      ),

      context_content_block_fixtures(
        fixture_name => 'partner_context_content_block_v2',

        page_fixture_name => 'partner_context_page',
        'opts'            => {
            'sources'           => undef,
            'grid_position'     => undef,
            'need_pictures'     => 1,
            'add_url_parameter' => 1,
            'doc_source'        => 'web',
            'news_params'       => {
                candidates => [
                    {
                        host => 'sadasda.com',
                        tags => ['qwe', 'asd_123'],
                    },
                    {host => 'asdsdaad.com',}
                ],
                filter_clicked => 1,
                model_type     => 'ctr',
            },
            'adv_positions' => [1, -1],
        },
      ),
      context_content_block_fixtures(
        fixture_name => 'partner_context_content_block_carousel',

        page_fixture_name => 'partner_context_page',
        'opts'            => {
            'strategy' => '1',
            'sources'  => [2900, 2990],
            'css'      => 'some custom css',
            'template' =>
              '<ya-units-slider>\n<ya-units-grid rows=${grid_rows} cols=${grid_columns}>\n</ya-units-slider>',
            'grid_rows'     => 1,
            'grid_columns'  => 5,
            'grid_position' => 3,
        },
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_picategories',

        page_fixture_name => 'partner_context_page',
        picategories      => [{category_id => 52, cpm => 100}],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_thematics',

        page_fixture_name => 'partner_context_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),

      internal_context_content_block_fixtures(
        fixture_name => 'internal_context_content_block_with_thematics',

        page_fixture_name => 'internal_context_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      context_natural_block_fixtures(
        fixture_name => 'partner_context_natural_block_with_thematics',

        page_fixture_name => 'partner_context_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      internal_context_natural_block_fixtures(
        fixture_name => 'internal_context_natural_block_with_thematics',

        page_fixture_name => 'internal_context_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),

      indoor_video_block_fixtures(
        fixture_name => 'partner_indoor_video_block_with_thematics',

        page_fixture_name => 'partner_indoor_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      outdoor_video_block_fixtures(
        fixture_name => 'partner_outdoor_video_block_with_thematics',

        page_fixture_name => 'partner_outdoor_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),

      inpage_video_block_fixtures(
        fixture_name => 'partner_inpage_video_block_with_thematics',

        page_fixture_name => 'partner_video_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      fullscreen_video_block_fixtures(
        fixture_name => 'partner_fullscreen_video_block_with_thematics',

        page_fixture_name => 'partner_video_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      instream_video_block_fixtures(
        fixture_name => 'partner_instream_video_block_with_thematics',

        page_fixture_name => 'partner_video_page',
        picategories      => [{category_id => 52, cpm => 100}],
        articles          => [{article_sid => 40, cpm => 100}],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_rewarded_only',

        page_fixture_name => 'partner_context_page_with_rewarded_only',

        design_templates => [
            {
                caption         => 'Основной дизайн',
                type            => 'tga',
                design_settings => {
                    name               => "rewarded",
                    limit              => 1,
                    rewarded           => 1,
                    fullscreenDuration => 10
                },
            },
        ],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_with_rewarded',

        page_fixture_name => 'partner_context_page_with_rewarded',

        design_templates => [
            {
                caption         => 'Основной дизайн',
                type            => 'tga',
                design_settings => {
                    name               => "rewarded",
                    limit              => 1,
                    rewarded           => 1,
                    fullscreenDuration => 10
                },
            },
            {
                caption         => 'Деф дизайн',
                type            => 'tga',
                design_settings => {
                    "name"              => "adaptive0418",
                    "limit"             => "1",
                    "favicon"           => JSON::XS::true,
                    "fontSize"          => "1.1",
                    "urlColor"          => "006600",
                    "textColor"         => "000000",
                    "borderType"        => "none",
                    "fontFamily"        => "",
                    "hoverColor"        => "DD0000",
                    "titleColor"        => "0000CC",
                    "imagesFirst"       => JSON::XS::false,
                    "noSitelinks"       => JSON::XS::true,
                    "siteBgColor"       => "FFFFFF",
                    "adaptiveWidth"     => "",
                    "titleFontSize"     => "3",
                    "adaptiveHeight"    => "",
                    "linksUnderline"    => JSON::XS::true,
                    "horizontalAlign"   => JSON::XS::true,
                    "bannerDescription" => "",
                },
            },
        ],
      ),
      context_rtb_block_fixtures(
        fixture_name => 'partner_context_rtb_block_media_performance_as_text',

        page_fixture_name => 'partner_context_page',

        strategy      => 3,
        text_cpm      => undef,
        text_active   => 1,
        text_blocked  => 1,
        media_cpm     => 19,
        media_active  => 1,
        media_blocked => undef,

        design_templates => [
            {
                caption         => 'Fixed design',
                type            => 'tga',
                design_settings => {
                    name            => "728x90",
                    limit           => 1,
                    urlColor        => "12468A",
                    borderType      => "block",
                    hoverColor      => "F69C0D",
                    titleColor      => "17775B",
                    borderColor     => "17775B",
                    borderRadius    => 0,
                    linksUnderline  => 0,
                    enableAnimation => 1,
                    horizontalAlign => 1
                },
            },
        ],
      ),
      ;
}

sub context_content_block_fixtures {
    my (%block_data) = @_;
    block_fixtures(
        %block_data,
        defaults                => {default_external_context_content_block_data()},
        block_table_name        => 'context_on_site_rtb',
        model                   => 'context_on_site_content',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'page_id',
    );
}

sub internal_context_content_block_fixtures {
    my (%block_data) = @_;
    block_fixtures(
        %block_data,
        defaults                => {default_internal_context_content_block_data()},
        block_table_name        => 'internal_context_on_site_content',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'id',
    );
}

sub context_natural_block_fixtures {
    my (%block_data) = @_;
    block_fixtures(
        %block_data,
        defaults                => {default_external_context_natural_block_data()},
        block_table_name        => 'context_on_site_natural',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'page_id',
    );
}

sub internal_context_natural_block_fixtures {
    my (%block_data) = @_;
    block_fixtures(
        %block_data,
        defaults                => {default_internal_context_natural_block_data()},
        block_table_name        => 'internal_context_on_site_natural',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'id',
    );
}

sub context_rtb_block_fixtures {
    my (%block_data) = @_;

    $block_data{design_templates} //= [
        {
            caption                 => "design template 240x400",
            type                    => $DEFAULT_DESIGN_TYPE,
            is_custom_format_direct => 0,
            design_settings         => {
                "name"  => "240x400",
                "limit" => 1,
            }
        },
        (
            $block_data{show_video}
            ? ({caption => "video design", type => "video", design_settings => {name => "inpage", limit => 1}})
            : ()
        ),
    ];
    push @{$block_data{design_templates}},
      {
        caption         => 'media design',
        type            => 'media',
        design_settings => {
            filterSizes     => JSON::XS::false,
            horizontalAlign => JSON::XS::false,
        }
      }
      unless grep {$_->{type} eq 'media'} @{$block_data{design_templates}};

    block_fixtures(
        %block_data,
        defaults              => {default_external_context_rtb_block_data()},
        block_table_name      => 'context_on_site_rtb',
        dsp_blocks_table_name => 'media_sizes',
        page_id_field_name    => 'campaign_id',

        page_page_id_field_name => 'page_id',
    );
}

sub context_adblock_block_fixtures {
    my (%block_data) = @_;

    block_fixtures(
        %block_data,
        defaults                => {default_context_adblock_block_data()},
        block_table_name        => 'context_on_site_adblock',
        page_id_field_name      => 'page_id',
        page_page_id_field_name => 'page_id',
    );
}

sub internal_context_rtb_block_fixtures {
    my (%block_data) = @_;

    $block_data{design_templates} //= [
        {
            caption                 => "design template 240x400",
            type                    => $DEFAULT_DESIGN_TYPE,
            is_custom_format_direct => 0,
            design_settings         => {
                "name"  => "240x400",
                "limit" => 1,
            }
        },
        (
            $block_data{show_video}
            ? ({caption => "video design", type => "video", design_settings => {name => "inpage", limit => 1}})
            : ()
        ),
    ];
    push @{$block_data{design_templates}},
      {
        caption         => 'media design',
        type            => 'media',
        design_settings => {
            filterSizes     => JSON::XS::false,
            horizontalAlign => JSON::XS::false,
        }
      }
      unless grep {$_->{type} eq 'media'} @{$block_data{design_templates}};

    block_fixtures(
        %block_data,
        defaults                => {default_internal_context_rtb_block_data()},
        block_table_name        => 'context_on_site_rtb',
        model                   => 'internal_context_on_site_rtb',
        dsp_blocks_table_name   => 'media_sizes',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'id',
    );
}

sub mobile_native_rtb_block_fixtures {
    my (%block_data) = @_;
    mobile_rtb_block_fixtures(%block_data, defaults => {default_external_mobile_native_rtb_block_data()},);
}

sub mobile_banner_rtb_block_fixtures {
    my (%block_data) = @_;
    mobile_rtb_block_fixtures(%block_data, defaults => {default_external_mobile_banner_rtb_block_data()},);
}

sub mobile_interstitial_rtb_block_fixtures {
    my (%block_data) = @_;
    mobile_rtb_block_fixtures(%block_data, defaults => {default_external_mobile_interstitial_rtb_block_data()},);
}

sub mobile_rewarded_rtb_block_fixtures {
    my (%block_data) = @_;
    mobile_rtb_block_fixtures(%block_data, defaults => {default_external_mobile_rewarded_rtb_block_data()},);
}

sub internal_mobile_native_rtb_block_fixtures {
    my (%block_data) = @_;
    internal_mobile_rtb_block_fixtures(%block_data, defaults => {default_internal_mobile_native_rtb_block_data()},);
}

sub internal_mobile_banner_rtb_block_fixtures {
    my (%block_data) = @_;
    internal_mobile_rtb_block_fixtures(%block_data, defaults => {default_internal_mobile_banner_rtb_block_data()},);
}

sub internal_mobile_interstitial_rtb_block_fixtures {
    my (%block_data) = @_;
    internal_mobile_rtb_block_fixtures(%block_data, defaults => {default_internal_mobile_interstitial_rtb_block_data()},
    );
}

sub mobile_rtb_block_fixtures {
    my (%block_data) = @_;

    block_fixtures(
        %block_data,
        block_table_name        => 'context_on_site_rtb',
        model                   => 'mobile_app_rtb',
        dsp_blocks_table_name   => 'media_sizes',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'context_page_id',
    );
}

sub internal_mobile_rtb_block_fixtures {
    my (%block_data) = @_;

    block_fixtures(
        %block_data,
        block_table_name        => 'context_on_site_rtb',
        model                   => 'internal_mobile_app_rtb',
        dsp_blocks_table_name   => 'media_sizes',
        page_id_field_name      => 'campaign_id',
        page_page_id_field_name => 'id',
    );
}

sub instream_video_block_fixtures {
    my (%block_data) = @_;
    video_block_fixtures(
        %block_data,
        defaults         => {default_instream_video_block_data()},
        block_table_name => 'video_an_site_instream',
    );
}

sub inpage_video_block_fixtures {
    my (%block_data) = @_;
    video_block_fixtures(
        %block_data,
        defaults         => {default_inpage_video_block_data()},
        block_table_name => 'video_an_site_inpage',
    );
}

sub fullscreen_video_block_fixtures {
    my (%block_data) = @_;
    video_block_fixtures(
        %block_data,
        defaults         => {default_fullscreen_video_block_data()},
        block_table_name => 'video_an_site_fullscreen',
    );
}

sub indoor_video_block_fixtures {
    my (%block_data) = @_;
    video_block_fixtures(
        %block_data,
        defaults                => {default_indoor_video_block_data()},
        block_table_name        => 'indoor_block',
        page_page_id_field_name => 'page_id',
    );
}

sub outdoor_video_block_fixtures {
    my (%block_data) = @_;
    video_block_fixtures(
        %block_data,
        defaults                => {default_outdoor_video_block_data()},
        block_table_name        => 'outdoor_block',
        page_page_id_field_name => 'page_id',
    );
}

sub video_block_fixtures {
    my (%block_data) = @_;

    block_fixtures(
        page_page_id_field_name => 'id',
        %block_data,
        dsp_blocks_table_name => 'video_an_site_block_dsp_blocks',
        page_id_field_name    => 'page_id',
    );
}

sub block_fixtures {
    my (%block_data) = @_;

    my (
        $fixture_name,             $defaults,                $page_fixture_name, $dsp_fixtures,
        $dsp_unmoderated_fixtures, $dsp_blocks,              $block_table_name,  $dsp_blocks_table_name,
        $page_id_field_name,       $page_page_id_field_name, $brands,            $articles,
        $design_templates,         $picategories,            $model
       )
      = delete @block_data{
        qw(
          fixture_name
          defaults
          page_fixture_name
          dsp_fixtures
          dsp_unmoderated_fixtures
          dsp_blocks
          block_table_name
          dsp_blocks_table_name
          page_id_field_name
          page_page_id_field_name
          brands
          articles
          design_templates
          picategories
          model
          )
      };

    my $default_dsp_fixtures = delete($defaults->{dsp_fixtures});
    my %block_dsps_fixtures  = block_dsps_fixtures(
        fixture_name       => "${fixture_name}_block_dsps",
        block_fixture_name => $fixture_name,
        page_id_field_name => $page_id_field_name,
        dsp_fixtures       => $dsp_fixtures // $default_dsp_fixtures,
    );

    my %block_dsps_unmoderated_fixtures;
    if ($dsp_unmoderated_fixtures && @$dsp_unmoderated_fixtures) {
        %block_dsps_unmoderated_fixtures = block_dsps_unmoderated_fixtures(
            fixture_name       => "${fixture_name}_block_dsps_unmoderated",
            block_fixture_name => $fixture_name,
            page_id_field_name => $page_id_field_name,
            dsp_fixtures       => $dsp_unmoderated_fixtures,
        );
    }

    my %dsp_blocks_fixtures;
    if ($dsp_blocks || $defaults->{dsp_blocks}) {
        my $default_dsp_blocks = delete($defaults->{dsp_blocks});
        %dsp_blocks_fixtures = dsp_blocks_fixtures(
            fixture_name             => "${fixture_name}_dsp_blocks",
            block_fixture_name       => $fixture_name,
            table_name               => $dsp_blocks_table_name,
            page_id_field_name       => 'page_id',
            block_page_id_field_name => $page_id_field_name,
            dsp_blocks               => $dsp_blocks // $default_dsp_blocks,
        );
    }

    my %design_templates_fixtures;
    if ($design_templates || $defaults->{design_templates}) {
        my $default_design_templates = delete($defaults->{design_templates});
        %design_templates_fixtures = design_templates_fixtures(
            fixture_name             => "${fixture_name}_design_templates",
            block_fixture_name       => $fixture_name,
            page_id_field_name       => 'page_id',
            block_page_id_field_name => $page_id_field_name,
            design_templates         => $design_templates // $default_design_templates,
        );
    }

    my @dicts;
    my %articles;
    if ($articles || $defaults->{articles}) {
        push @dicts, 'tns_dict_article';
        %articles = articles_blocks_fixtures(
            fixture_name       => "${fixture_name}_articles_blocks",
            block_fixture_name => $fixture_name,
            page_id_field_name => $page_id_field_name,
            articles           => $articles || $defaults->{articles},
        );
    }

    my %brands;
    if ($brands) {
        push @dicts, 'tns_dict_brand';
        %brands = brands_blocks_fixtures(
            fixture_name       => "${fixture_name}_brands_blocks",
            block_fixture_name => $fixture_name,
            page_id_field_name => $page_id_field_name,
            brands             => $brands,
        );
    }

    my %picategories;
    if ($picategories) {
        push @dicts, 'picategories_dict';
        %picategories = picategories_blocks_fixtures(
            fixture_name       => "${fixture_name}_picategories_blocks",
            block_fixture_name => $fixture_name,
            page_id_field_name => $page_id_field_name,
            picategories       => $picategories,
        );
    }

    return (
        $fixture_name => {
            deps            => [$page_fixture_name, qw(partner_db block_id_provider), @dicts],
            validate_models => [$block_table_name],
            next            => [
                keys(%dsp_blocks_fixtures),             keys(%block_dsps_fixtures),
                keys(%block_dsps_unmoderated_fixtures), keys(%brands),
                keys(%articles),                        keys(%design_templates_fixtures),
                keys(%picategories),
            ],
            sub => sub {
                my (%opts) = @_;

                my %keys = (
                    $page_id_field_name => $opts{$page_fixture_name}->{$page_page_id_field_name},
                    id                  => $opts{block_id_provider}->(),
                );

                my %table_fields = map {$_ => 1} $opts{partner_db}->$block_table_name->field_names();

                my $model_type = $model // $block_table_name;

                if ($table_fields{model}) {
                    $block_data{model} = $model_type;
                }

                if ($table_fields{unique_id}) {
                    $block_data{unique_id} = make_unique_id($model_type, $keys{$page_id_field_name}, $keys{id});
                }

                my $db_row = merge_db_hashes($defaults, \%keys, \%block_data,);
                foreach (sort keys(%$db_row)) {
                    if (!$table_fields{$_}) {
                        $db_row->{'opts'}{$_} = delete($db_row->{$_});
                    }
                }

                $opts{partner_db}->$block_table_name->add(opts_to_json($db_row));

                return \%keys;
            },
        },
        %dsp_blocks_fixtures,

        %block_dsps_fixtures,
        %block_dsps_unmoderated_fixtures,
        %brands,
        %articles,
        %picategories,
        %design_templates_fixtures,
    );
}

sub block_dsps_fixtures {
    my (%block_dsps_data) = @_;

    my ($fixture_name, $block_fixture_name, $page_id_field_name, $dsp_fixtures) =
      delete @block_dsps_data{qw(fixture_name block_fixture_name page_id_field_name dsp_fixtures)};

    return (
        $fixture_name => {
            deps => ['partner_db', $block_fixture_name, @$dsp_fixtures],
            sub  => sub {
                my (%opts) = @_;

                my $dsps = [
                    map {
                        {
                            page_id    => $opts{$block_fixture_name}{$page_id_field_name},
                            block_id   => $opts{$block_fixture_name}{id},
                            dsp_id     => $opts{$_}{id},
                            is_deleted => 0,
                        }
                      } @$dsp_fixtures
                ];

                $opts{partner_db}->block_dsps->add_multi($dsps);

                return $dsps;
            },
        },
    );
}

sub block_dsps_unmoderated_fixtures {
    my (%block_dsps_data) = @_;

    my ($fixture_name, $block_fixture_name, $page_id_field_name, $dsp_fixtures) =
      delete @block_dsps_data{qw(fixture_name block_fixture_name page_id_field_name dsp_fixtures)};

    return (
        $fixture_name => {
            deps => ['partner_db', $block_fixture_name, @$dsp_fixtures],
            sub  => sub {
                my (%opts) = @_;

                my $dsps = [
                    map {
                        {
                            page_id  => $opts{$block_fixture_name}{$page_id_field_name},
                            block_id => $opts{$block_fixture_name}{id},
                            dsp_id   => $opts{$_}{id},
                        }
                      } @$dsp_fixtures
                ];

                $opts{partner_db}->block_dsps_unmoderated->add_multi($dsps);

                return $dsps;
            },
        },
    );
}

sub dsp_blocks_fixtures {
    my (%dsp_blocks_data) = @_;

    my ($fixture_name, $block_fixture_name, $table_name, $page_id_field_name, $dsp_blocks, $block_page_id_field_name) =
      delete @dsp_blocks_data{
        qw(fixture_name block_fixture_name table_name page_id_field_name dsp_blocks block_page_id_field_name)};

    return (
        $fixture_name => {
            deps => ['partner_db', $block_fixture_name],
            sub  => sub {
                my (%opts) = @_;

                my $dsp_blocks = [
                    map {
                        {
                            $page_id_field_name => $opts{$block_fixture_name}{$block_page_id_field_name},
                              block_id          => $opts{$block_fixture_name}{id},
                              type              => $_,
                        }
                      } (@$dsp_blocks),
                ];
                $opts{partner_db}->$table_name->add_multi($dsp_blocks);

                return $dsp_blocks;
            },
        },
    );
}

sub design_templates_fixtures {
    my (%design_templates_data) = @_;

    my ($fixture_name, $block_fixture_name, $page_id_field_name, $design_templates, $block_page_id_field_name) =
      delete @design_templates_data{
        qw(fixture_name block_fixture_name page_id_field_name design_templates block_page_id_field_name)};

    return (
        $fixture_name => {
            deps => ['partner_db', $block_fixture_name],
            sub  => sub {
                my (%opts) = @_;

                my $cntr             = 0;
                my $design_templates = [
                    map {
                        {
                            page_id     => $opts{$block_fixture_name}{$block_page_id_field_name},
                            block_id    => $opts{$block_fixture_name}{id},
                            caption     => $_->{caption},
                            type        => $_->{type},
                            update_time => '2019-03-29 10:12:34',
                            opts        => to_json(
                                {
                                    filter_tags             => $_->{filter_tags},
                                    design_settings         => $_->{design_settings},
                                    is_custom_format_direct => $_->{is_custom_format_direct}
                                },
                                pretty => 1
                            )
                        }
                      } (@$design_templates),
                ];
                $opts{partner_db}->design_templates->add_multi($design_templates);

                return $design_templates;
            },
        },
    );
}

sub brands_blocks_fixtures {
    my (%data) = @_;

    my ($fixture_name, $brands, $block_fixture_name, $page_id_field_name) =
      delete @data{qw(fixture_name brands block_fixture_name page_id_field_name)};

    return $fixture_name => {
        deps => ['partner_db', 'tns_dict_brand', $block_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $filter   = $opts{$block_fixture_name};
            my $page_id  = $filter->{$page_id_field_name};
            my $block_id = $filter->{id};
            $opts{partner_db}->brands->add_multi(
                [
                    map +{
                        page_id  => $page_id,
                        block_id => $block_id,
                        bid      => $_->{bid},
                        blocked  => $_->{blocked},
                        cpm      => $_->{cpm},
                    },
                    @$brands
                ],
                replace => 1
            );

            return;
        },
    };
}

sub default_context_natural_block_data {
    # General
    'comment'       => undef,
      'multistate'  => '2',
      'create_date' => '2018-10-11 17:08:15',
      'geo'         => '[]',
      # DSPS
      'dsp_fixtures' => [qw(dsp_direct)],
      # Godmode
      'is_custom_bk_data' => '0',
      'bk_data'           => undef,
      'opts'              => {
        'articles'     => undef,
        'grid_rows'    => 3,
        'grid_columns' => 3,
        'strategy'     => '1',
        'css'          => 'some custom css',
        'template'     => '<ya-units-grid rows=${grid_rows} cols=${grid_columns}>',
      },
      'site_version' => 'general',
      ;
}

sub articles_blocks_fixtures {
    my (%data) = @_;

    my ($fixture_name, $articles, $block_fixture_name, $page_id_field_name) =
      delete @data{qw(fixture_name articles block_fixture_name page_id_field_name)};

    return $fixture_name => {
        deps => ['partner_db', 'tns_dict_article', $block_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $filter   = $opts{$block_fixture_name};
            my $page_id  = $filter->{$page_id_field_name};
            my $block_id = $filter->{id};
            $opts{partner_db}->articles->add_multi(
                [
                    map +{
                        page_id     => $page_id,
                        block_id    => $block_id,
                        article_sid => $_->{article_sid},
                        cpm         => $_->{cpm},
                    },
                    @$articles
                ],
                replace => 1
            );

            return;
        },
    };
}

sub picategories_blocks_fixtures {
    my (%data) = @_;

    my ($fixture_name, $picategories, $block_fixture_name, $page_id_field_name) =
      delete @data{qw(fixture_name picategories block_fixture_name page_id_field_name)};

    return $fixture_name => {
        deps => ['partner_db', 'picategories_dict', $block_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $filter   = $opts{$block_fixture_name};
            my $page_id  = $filter->{$page_id_field_name};
            my $block_id = $filter->{id};
            $opts{partner_db}->picategories->add_multi(
                [
                    map +{
                        page_id     => $page_id,
                        block_id    => $block_id,
                        category_id => $_->{category_id},
                        cpm         => $_->{cpm},
                    },
                    @$picategories
                ],
                replace => 1
            );

            return;
        },
    };
}

sub default_context_content_block_data {
    # General
    'comment'       => undef,
      'multistate'  => '2',
      'create_date' => '2018-10-11 17:08:15',
      'geo'         => '[]',
      # DSPS
      'dsp_fixtures' => [qw(dsp_direct)],
      # Godmode
      'is_custom_bk_data' => '0',
      'bk_data'           => undef,
      'opts'              => {
        'strategy' => '1',

        'sources'       => [2900, 2990],
        'css'           => 'some custom css',
        'template'      => '<ya-units-grid rows=${grid_rows} cols=${grid_columns}>',
        'grid_rows'     => 1,
        'grid_columns'  => 5,
        'grid_position' => 3,
        'dsp_mode'      => 'force',
      },
      site_version => 'general',
      ;
}

sub default_context_rtb_block_data {
    # General
    'comment'        => undef,
      'multistate'   => '2',
      'create_date'  => '2018-10-11 17:08:15',
      'geo'          => '[]',
      'blind'        => '0',
      'show_video'   => '0',
      'site_version' => 'desktop',
      # DSPS
      'dsp_fixtures' => [qw(dsp_direct)],
      # DSP Blocks
      'dsp_blocks' => [qw(728x90)],
      # Godmode
      'is_custom_bk_data' => '0',
      'bk_data'           => undef,
      # Strategy
      'alternative_code' => '',
      'media_active'     => undef,
      'media_blocked'    => undef,
      'media_cpm'        => undef,
      'text_active'      => undef,
      'text_blocked'     => undef,
      'text_cpm'         => undef,
      'video_active'     => undef,
      'video_blocked'    => undef,
      'video_cpm'        => undef,
      'mincpm'           => undef,
      'strategy'         => '1',
      # Direct-RTB
      'active'           => '1',
      'ex_direct'        => '0',
      'duplicate_direct' => '0',
      # Direct appearance
      'horizontal_align' => '1',
      # JSON field
      'opts' => {'dsp_mode' => 'force',},
      ;
}

sub default_external_context_content_block_data {
    default_context_content_block_data(),
      # General
      'caption' => 'Mocked External Context Content Block',
      # Direct appearance
      ;
}

sub default_internal_context_content_block_data {
    default_context_content_block_data(),
      'caption' => 'Mocked Internal Context Content Block',
      ;
}

sub default_external_context_natural_block_data {
    default_context_natural_block_data(),
      # General
      'caption' => 'Mocked External Context natural Block',
      # Direct appearance
      ;
}

sub default_internal_context_natural_block_data {
    default_context_natural_block_data(),
      'caption' => 'Mocked Internal Context natural Block',
      ;
}

sub default_external_context_rtb_block_data {
    default_context_rtb_block_data(),
      # General
      'caption' => 'Mocked External Context RTB Block',
      # Direct appearance
      'alt_width'  => undef,
      'alt_height' => undef,
      # ADFOX
      'adfox_block' => '0',
      ;
}

sub default_internal_context_rtb_block_data {
    default_context_rtb_block_data(),
      'caption' => 'Mocked Internal Context RTB Block',
      ;
}

sub default_context_adblock_block_data {
    'caption'             => 'Mocked Adblock Block',
      'multistate'        => 2,
      'direct_block'      => 'vertical',
      'limit'             => 9,
      'strategy'          => 0,
      'mincpm'            => 0,
      'dsp_fixtures'      => ['dsp_direct'],
      'show_video'        => '0',
      'comment'           => '',
      'is_custom_bk_data' => 0,
      'bk_data'           => undef,
      ;
}

sub default_mobile_rtb_block_data {
    'create_date'               => '2018-10-10 21:39:05',
      'favicon'                 => 0,
      'no_sitelinks'            => 0,
      'multistate'              => '2',
      'geo'                     => '[]',
      'mincpm'                  => undef,
      'adaptive_width'          => '',
      'adaptive_height'         => '',
      'bk_data'                 => undef,
      'is_custom_bk_data'       => 0,
      'media_active'            => undef,
      'media_blocked'           => undef,
      'media_cpm'               => undef,
      'text_active'             => undef,
      'text_blocked'            => undef,
      'text_cpm'                => undef,
      'strategy'                => '1',
      'is_custom_format_direct' => '0',
      'comment'                 => undef,
      'opts'                    => {'mobile_app_mode' => 0, 'dsp_mode' => 'force',},
      ;
}

sub default_external_mobile_rtb_block_data {
    %{
        merge_db_hashes(
            {default_mobile_rtb_block_data()},
            {
                'adfox_block'          => '0',
                'opts'                 => {'is_mobile_mediation' => 0,},
                'limit'                => undef,
                'alternative_code'     => '',
                'no_sitelinks'         => '0',
                'callouts'             => undef,
                'font_family'          => undef,
                'font_size'            => undef,
                'title_font_size'      => undef,
                'url_background_color' => undef,
                'show_video'           => '0',
            }
        )
      };
}

sub default_internal_mobile_rtb_block_data {
    default_mobile_rtb_block_data(),;
}

sub default_mobile_native_rtb_block_data {
    'block_type'         => 'native',
      'caption'          => 'Mocked Native Mobile Block',
      'direct_block'     => 'native',
      'media_block'      => 'native',
      'border_radius'    => undef,
      'border_type'      => undef,
      'favicon'          => '0',
      'links_underline'  => undef,
      'site_bg_color'    => undef,
      'bg_color'         => undef,
      'border_color'     => undef,
      'header_bg_color'  => undef,
      'sitelinks_color'  => undef,
      'title_color'      => undef,
      'text_color'       => undef,
      'url_color'        => undef,
      'hover_color'      => undef,
      'horizontal_align' => undef,
      'dsp_blocks'       => [qw(native)],
      'dsp_fixtures'     => [qw(dsp_direct)],
      ;
}

sub default_mobile_banner_rtb_block_data {
    'block_type'     => 'banner',
      'caption'      => 'Mocked Banner Mobile Block',
      'direct_block' => '300x250',
      'media_block'  => '300x250',
      'dsp_blocks'   => ['300x250'],
      'favicon'      => '1',
      'dsp_fixtures' => [
        qw(
          dsp_direct
          )
      ],
      ;
}

sub default_mobile_interstitial_rtb_block_data {
    'block_type'     => 'interstitial',
      'caption'      => 'Мобильный RTB-блок',
      'direct_block' => '320x480',
      'media_block'  => '320x480',
      'favicon'      => '0',
      'dsp_fixtures' => [
        qw(
          dsp_direct
          )
      ],
      'dsp_blocks' => [qw(320x480 480x320 240x400 400x240 300x250 300x300)],
      'opts'       => {'close_button_delay' => 2},
      ;
}

sub default_mobile_external_interstitial_rtb_block_data {
    %{merge_db_hashes({default_external_mobile_rtb_block_data()}, {default_mobile_interstitial_rtb_block_data()},)};
}

sub default_mobile_internal_interstitial_rtb_block_data {
    %{merge_db_hashes({default_internal_mobile_rtb_block_data()}, {default_mobile_interstitial_rtb_block_data()},)};
}

sub default_mobile_rewarded_rtb_block_data {
    'block_type'     => 'rewarded',
      'caption'      => 'Rewarded RTB-блок',
      'direct_block' => '320x480',
      'media_block'  => '320x480',
      'favicon'      => '0',
      'opts'         => {currency_value => 10, currency_type => 'coins', mobile_app_mode => 0,},
      dsp_blocks     => [qw(320x480 480x320 240x400 400x240 300x250 300x300)],
      'dsp_fixtures' => [
        qw(
          dsp_direct
          )
      ],
      ;
}

sub default_mobile_not_native_rtb_block_data {
    'border_radius'      => '0',
      'border_type'      => 'block',
      'links_underline'  => '1',
      'site_bg_color'    => 'FFFFFF',
      'bg_color'         => 'FFFFFF',
      'border_color'     => 'DDDCDA',
      'header_bg_color'  => 'FFFFFF',
      'sitelinks_color'  => '00AAFF',
      'title_color'      => '0000CC',
      'text_color'       => '000000',
      'url_color'        => '000000',
      'hover_color'      => '0066FF',
      'horizontal_align' => '1',
      ;
}

sub default_external_mobile_native_rtb_block_data {
    default_external_mobile_rtb_block_data(), default_mobile_native_rtb_block_data(),;
}

sub default_external_mobile_banner_rtb_block_data {
    default_external_mobile_rtb_block_data(), default_mobile_banner_rtb_block_data(),
      default_mobile_not_native_rtb_block_data(),;
}

sub default_external_mobile_interstitial_rtb_block_data {
    default_mobile_external_interstitial_rtb_block_data(), default_mobile_not_native_rtb_block_data(),;
}

sub default_external_mobile_rewarded_rtb_block_data {
    default_external_mobile_rtb_block_data(), default_mobile_rewarded_rtb_block_data(),
      default_mobile_not_native_rtb_block_data(),;
}

sub default_internal_mobile_native_rtb_block_data {
    default_internal_mobile_rtb_block_data(), default_mobile_native_rtb_block_data(),;
}

sub default_internal_mobile_banner_rtb_block_data {
    default_internal_mobile_rtb_block_data(), default_mobile_banner_rtb_block_data(),
      default_mobile_not_native_rtb_block_data(),;
}

sub default_internal_mobile_interstitial_rtb_block_data {
    default_mobile_internal_interstitial_rtb_block_data(), default_mobile_not_native_rtb_block_data(),;
}

sub default_video_block_data {
    'create_date'                 => '2018-10-10 22:51:22',
      'multistate'                => '2',
      'geo'                       => '[]',
      'blind'                     => '0',
      'category_id'               => '0',
      'category_path'             => 'Основной видеоресурс',
      'mincpm'                    => '0',
      'strategy'                  => '0',
      'video_active'              => undef,
      'video_blocked'             => undef,
      'video_cpm'                 => undef,
      'video_performance_active'  => undef,
      'video_performance_blocked' => undef,
      'video_performance_cpm'     => undef,
      'comment'                   => '',
      'is_custom_bk_data'         => '0',
      'bk_data'                   => undef,
      'adfox_block'               => '0',
      'video_motion'              => '1',
      'alternative_code'          => '',
      'max_duration'              => '60',
      'dsp_fixtures'              => [qw(dsp_direct dsp_awaps_video_auction)],
      ;
}

sub default_instream_video_block_data {
    default_video_block_data(),
      'caption'                => 'Mocked Instream Block',
      'type'                   => '1',
      'start_time'             => undef,
      'count_positions'        => '1',
      'custom_bk_options'      => [],
      'allow_multiple_dsp_ads' => '1',
      'repeat'                 => undef,
      'broadcast_replace'      => undef,
      'pip'                    => undef,
      'repeat_after'           => undef,
      'max_repeat_count'       => undef,
      'server_side'            => undef,
      'try_client'             => undef,
      'vmap_id'                => 1,
      'opts'                   => {'dsp_mode' => 'force',},
      ;
}

sub default_inpage_video_block_data {
    default_video_block_data(),
      'caption'         => 'Mocked Inpage Block',
      'type'            => '5',
      'hide_at_the_end' => '0',
      'auto_repeat'     => '0',
      'stick_outstream' => '0',
      'opts'            => {'preload' => 0, 'dsp_mode' => 'force',},
      ;
}

sub default_fullscreen_video_block_data {
    default_video_block_data(),
      'caption' => 'Fullscreen видеоблок',
      'type'    => '3',
      'opts'    => {
        'order_tags'  => [2, 4],
        'target_tags' => [5],
        'dsp_mode'    => 'force',
      };
}

sub default_indoor_video_block_data {
    'multistate'    => '130',
      'create_date' => '2018-10-10 22:51:22',
      'opts'        => {
        'caption'                => 'Mocked Indoor Block',
        'resolution'             => '1920x1080',
        'touch_screen'           => '0',
        'sound'                  => '0',
        'zone_category'          => '1',
        'max_duration'           => 60,
        'strategy'               => 0,
        'mincpm'                 => 0,
        'address'                => 'Mocked Indoor Block address',
        'gps'                    => '-11.1,66.6',
        'aspect_ratio'           => '4:3',
        'min_duration'           => 12,
        'facility_type'          => 1,
        'photo_id_list'          => [],
        'photo_id_list_approved' => [],
        'moderation'             => {'photo_id_list' => {},},
        'dsp_mode'               => 'force',
      },
      'dsp_fixtures' => [qw(dsp_direct dsp_awaps_video_auction)],
      ;
}

sub default_outdoor_video_block_data {
    'multistate'    => '130',
      'create_date' => '2018-10-10 22:51:22',
      'opts'        => {
        'caption'                => 'Mocked Outdoor Block',
        'caption_approved'       => 'Mocked Outdoor Block (approved)',
        'resolution'             => '1800x900',
        'min_duration'           => 3,
        'max_duration'           => 60,
        'strategy'               => 0,
        'mincpm'                 => 0,
        'slot_duration'          => 30000,
        'facility_type'          => 1,
        'address'                => 'Mocked Outdoor Block address',
        'address_approved'       => 'Mocked Outdoor Block address (approved)',
        'gps'                    => '-11.1,66.6',
        'gps_approved'           => '-11.1,66.6',
        'direction'              => 9,
        'width'                  => 4,
        'height'                 => 3,
        'photo_id_list'          => [],
        'photo_id_list_approved' => [],
        'moderation'             => {
            'caption'       => {'Mocked Outdoor Block (approved)'         => {'request_id' => '', 'verdict' => 1}},
            'photo_id_list' => {},
            'address'       => {'Mocked Outdoor Block address (approved)' => {'request_id' => '', 'verdict' => 1}},
            'gps'           => {'-11.1,66.6'                              => {'request_id' => '', 'verdict' => 1}},
        },
        'dsp_mode' => 'force',
      },
      'dsp_fixtures' => [qw(dsp_direct dsp_awaps_video_auction)],
      ;
}

1;
