package Test::Partner2::Fixture::DB::DSP;

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Fixture::DB::Utils;

use PiConstants;

# These dsps should be loaded first, because their ids are referenced in dsp rules
# So it should be mocked before we create any fake dsp
# Otherwise id collision is guaranteed
my %special_dsps = (
    map {$_ => 1} (
        qw(
          dsp_direct
          dsp_awaps
          dsp_own_adv
          dsp_unsold
          dsp_awaps_video_auction
          dsp_awaps_video_auction_in_banner
          dsp_awaps_video_in_banner
          dsp_awaps_mobile
          dsp_video_interstitial_mobile_10
          dsp_video_interstitial_mobile_7
          dsp_video_interstitial_mobile_12
          )
    ),
);

sub get_fixtures {
    return (
        dsp_fixtures(
            fixture_name => 'dsp_direct',

            owner_fixture_name => 'mocked_dsp_manager',

            short_caption           => 'Директ',
            url                     => 'http://yabs.yandex.ru/',
            test_url                => '',
            multistate              => 175,
            data_key                => '',
            tag                     => 'yabs',
            unmoderated_rtb_auction => 0,
            postmoderated           => 0,
            show_probability        => 100,

            dsp_types   => [0, 1, 2],
            dsp_formats => [1, 2],

            mock_id_callback => sub {$PiConstants::DSP_DIRECT_ID = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_awaps',

            owner_fixture_name => 'mocked_dsp_manager',

            'multistate'       => '143',
            'short_caption'    => 'AWAPS',
            'url'              => 'http://awaps.yandex.ru/11/1/0?r_host_id=1&charset=utf-8&rtb_as_ssi=1',
            'test_url'         => 'http://awaps-test02g.yandex.net/11/1/0?r_host_id=1&charset=utf-8&rtb_as_ssi=1',
            'skipnoud'         => '0',
            'tag'              => 'awaps',
            'data_key'         => '',
            'show_probability' => '100',
            'postmoderated'    => '0',
            'unmoderated_rtb_auction' => '0',

            dsp_types => [0],

            mock_id_callback => sub {$PiConstants::DSP_AWAPS_ID = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_own_adv',

            owner_fixture_name => 'mocked_dsp_manager',

            technical_dsp_data(),
            short_caption => 'Своя реклама',
            tag           => 'local',

            dsp_types => [0],

            mock_id_callback => sub {$PiConstants::DSP_OWN_ADV_ID = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_unsold',

            owner_fixture_name => 'mocked_dsp_manager',

            technical_dsp_data(),
            short_caption => 'Непроданные',
            tag           => 'default',

            dsp_types => [0],

            mock_id_callback => sub {$PiConstants::DSP_UNSOLD_ID = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_awaps_video_auction',

            owner_fixture_name => 'mocked_dsp_manager',

            'multistate'              => '1069',
            'short_caption'           => 'AWAPSVideoAuction',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=10&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => '',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',

            dsp_types => [1],

            mock_id_callback => sub {
                $PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[2] = $_[0]->{id};
                $PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[2] = $_[0]->{id};
                $PiConstants::VIDEO_DEFAULT_DSPS[1]                              = $_[0]->{id};

                $#PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::VIDEO_DEFAULT_DSPS                              = 1;
            },
        ),
        dsp_fixtures(
            fixture_name => 'dsp_awaps_video_auction_in_banner',

            owner_fixture_name => 'mocked_dsp_manager',

            'short_caption'           => 'AWAPSVideoAuctionInBanner',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=10&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => 'http://awaps.yandex.ru/11/1/0?r_host_id=10&charset=utf-8&rtb_as_ssi=1',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',
            'multistate'              => '47',

            dsp_types => [0, 1],

            mock_id_callback => sub {
                $PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[0] = $_[0]->{id};
                $PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[0] = $_[0]->{id};
                $PiConstants::VIDEO_AWAPS_DSPS[0]                                = $_[0]->{id};

                $#PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::VIDEO_AWAPS_DSPS                                = 1;
            },
        ),
        dsp_fixtures(
            fixture_name => 'dsp_awaps_video_in_banner',

            owner_fixture_name => 'mocked_dsp_manager',

            'short_caption'           => 'AWAPSVideoInBanner',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=7&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => 'http://awaps.yandex.ru/11/1/0?r_host_id=7&charset=utf-8&rtb_as_ssi=1',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',
            'multistate'              => '47',

            dsp_types => [0, 1],

            mock_id_callback => sub {
                $PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[1] = $_[0]->{id};
                $PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS[1] = $_[0]->{id};
                $PiConstants::VIDEO_AWAPS_DSPS[1]                                = $_[0]->{id};

                $#PiConstants::EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = 2;
                $#PiConstants::VIDEO_AWAPS_DSPS                                = 1;
            },
        ),
        dsp_fixtures(
            fixture_name => 'dsp_awaps_mobile',

            owner_fixture_name => 'mocked_dsp_manager',

            'multistate'       => '47',
            'short_caption'    => 'AWAPS Mobile',
            'url'              => 'http://awaps.yandex.ru/11/1/0?r_host_id=1&charset=utf-8&rtb_as_ssi=1',
            'test_url'         => 'http://awaps-test02g.yandex.net/11/1/0?r_host_id=1&charset=utf-8&rtb_as_ssi=1',
            'skipnoud'         => '0',
            'tag'              => 'awaps',
            'data_key'         => '9848c606987f060e94fd98145d2367e8',
            'show_probability' => '100',
            'postmoderated'    => '0',
            'unmoderated_rtb_auction' => '0',

            dsp_types   => [2],
            dsp_formats => [1],

            mock_id_callback => sub {
                $PiConstants::DSP_AWAPS_MOBILE_ID = $_[0]->{id};
            },
        ),
        dsp_fixtures(
            fixture_name => 'dsp_video_interstitial_mobile_10',

            owner_fixture_name => 'mocked_dsp_manager',

            'short_caption'           => 'VideoInterstitial-mobile-10',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=10&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => '',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',
            'multistate'              => '1069',

            dsp_types   => [1, 2],
            dsp_formats => [1, 3],

            mock_id_callback => sub {
                $PiConstants::VIDEO_INTERSTITIAL_MOBILE_ID = $_[0]->{id};
                $PiConstants::VIDEO_INTERSTITIAL_DSPS[1]   = $_[0]->{id};
                $PiConstants::VIDEO_BANNER_DSPS[0]         = $_[0]->{id};
            },
        ),
        dsp_fixtures(
            fixture_name => 'dsp_video_interstitial_mobile_7',

            owner_fixture_name => 'mocked_dsp_manager',

            'short_caption'           => 'Videointerstitial-mobile-7',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=7&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => '',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',
            'multistate'              => '1069',

            dsp_types   => [1, 2],
            dsp_formats => [1, 3],

            mock_id_callback => sub {$PiConstants::VIDEO_INTERSTITIAL_DSPS[0] = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_video_interstitial_mobile_12',

            owner_fixture_name => 'mocked_dsp_manager',

            'multistate'              => '1069',
            'short_caption'           => 'VideoInsterstitial_mobile-12',
            'url'                     => 'http://awaps.yandex.ru/11/1/0?r_host_id=12&charset=utf-8&rtb_as_ssi=1',
            'test_url'                => '',
            'skipnoud'                => '0',
            'tag'                     => 'awaps',
            'data_key'                => '9848c606987f060e94fd98145d2367e8',
            'show_probability'        => '100',
            'postmoderated'           => '0',
            'unmoderated_rtb_auction' => '0',

            dsp_types   => [1, 2],
            dsp_formats => [1, 3],

            mock_id_callback => sub {$PiConstants::VIDEO_INTERSTITIAL_DSPS[2] = $_[0]->{id}},
        ),
        dsp_fixtures(
            fixture_name => 'dsp_media',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Media DSP',

            dsp_types => [0],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_media_working_on_all_platforms',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'WOAP Media DSP',    # Working On All Platforms
            multistate    => 143,

            dsp_types => [0],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_media_working_on_yandex_services',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'WOYS Media DSP',    # Working On Yandex Services
            multistate    => 271,

            dsp_types => [0],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_video',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Video DSP',

            dsp_types => [1],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_mobile',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Mobile DSP',

            dsp_types   => [2],
            dsp_formats => [1, 2],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_media_video_mobile',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Media-Video-Mobile DSP',

            dsp_types   => [0, 1, 2],
            dsp_formats => [1],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_media_video_mobile_with_internal_tag',

            owner_fixture_name => 'mocked_dsp_manager',

            short_caption => 'YaBS Media-Video-Mobile DSP',

            tag => 'yabs',

            dsp_types   => [0, 1, 2],
            dsp_formats => [1],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_deleted',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Deleted DSP',
            multistate    => 71,

            dsp_types   => [0, 1, 2],
            dsp_formats => [1],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_disabled',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Disabled DSP',
            multistate    => 7,

            dsp_types   => [0, 1, 2],
            dsp_formats => [1],
        ),
        special_dsps => {
            deps => [sort keys(%special_dsps)],
            sub  => sub { },
        },
        dsp_fixtures(
            fixture_name => 'dsp_nonmoder',

            owner_fixture_name => 'mocked_dsp_manager',

            short_caption           => 'Criteo Banner OpenRTB 2.5',
            url                     => 'http://rtb.nl.eu.criteo.com/yandex/auction/request?profile=270',
            test_url                => '',
            multistate              => 47,
            data_key                => '',
            tag                     => 'criteortb2',
            unmoderated_rtb_auction => 1,
            postmoderated           => 1,
            show_probability        => 100,

            dsp_types   => [0, 1, 2],
            dsp_formats => [1],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_mobile_native',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Native Mobile DSP',

            dsp_types   => [2],
            dsp_formats => [2],
        ),
        dsp_fixtures(
            fixture_name => 'dsp_mobile_banner',

            owner_fixture_name => 'mocked_dsp_partner',

            short_caption => 'Banner Mobile DSP',

            dsp_types   => [2],
            dsp_formats => [1],
        ),
    );
}

sub dsp_fixtures {
    my (%dsp_data) = @_;

    my ($fixture_name, $owner_fixture_name, $dsp_types, $dsp_formats, $mock_id_callback,) = delete @dsp_data{
        qw(
          fixture_name
          owner_fixture_name
          dsp_types
          dsp_formats
          mock_id_callback
          )
      };

    my $defaults            = {default_dsp_data()};
    my $default_dsp_types   = delete($defaults->{dsp_types});
    my $default_dsp_formats = delete($defaults->{dsp_formats});

    my %types_fixtures = dsp_types_fixtures(
        fixture_name     => "${fixture_name}_types",
        dsp_fixture_name => $fixture_name,
        dsp_types        => $dsp_types // $default_dsp_types,
    );

    my %formats_fixtures = dsp_formats_fixtures(
        fixture_name     => "${fixture_name}_formats",
        dsp_fixture_name => $fixture_name,
        dsp_formats      => $dsp_formats // $default_dsp_formats,
    );

    return (
        $fixture_name => {
            deps => ['partner_db', $owner_fixture_name, $special_dsps{$fixture_name} ? () : keys(%special_dsps)],
            validate_models => ['dsp'],
            next            => [keys(%types_fixtures), keys(%formats_fixtures)],
            sub             => sub {
                my (%opts) = @_;

                my $pk = $opts{partner_db}->dsp->add(
                    opts_to_json(
                        merge_db_hashes($defaults, \%dsp_data, {'owner_id' => $opts{$owner_fixture_name}{id}})
                    )
                );

                my $pk_hash = pk_to_hash($opts{partner_db}->dsp, $pk);

                $mock_id_callback->($pk_hash) if defined($mock_id_callback);

                return $pk_hash;
            },
        },
        %types_fixtures,
        %formats_fixtures,
    );
}

sub dsp_types_fixtures {
    my (%types_data) = @_;

    my ($fixture_name, $dsp_fixture_name, $dsp_types) = delete @types_data{
        qw(
          fixture_name
          dsp_fixture_name
          dsp_types
          )
      };

    return (
        $fixture_name => {
            deps => ['partner_db', $dsp_fixture_name],
            sub  => sub {
                my (%opts) = @_;

                my $types = [map {{dsp_id => $opts{$dsp_fixture_name}{id}, type_id => $_,}} @$dsp_types,];

                $opts{partner_db}->dsp_type->add_multi($types);

                return $types;
            },
        },
    );
}

sub dsp_formats_fixtures {
    my (%formats_data) = @_;

    my ($fixture_name, $dsp_fixture_name, $dsp_formats) = delete @formats_data{
        qw(
          fixture_name
          dsp_fixture_name
          dsp_formats
          )
      };

    return (
        $fixture_name => {
            deps => ['partner_db', $dsp_fixture_name],
            sub  => sub {
                my (%opts) = @_;

                my $formats = [map {{dsp_id => $opts{$dsp_fixture_name}{id}, format_id => $_,}} @$dsp_formats,];

                $opts{partner_db}->dsp_format->add_multi($formats);

                return $formats;
            },
        },
    );
}

sub technical_dsp_data {
    url                       => '',
      test_url                => '',
      multistate              => 15,
      data_key                => '',
      tag                     => 'local',
      unmoderated_rtb_auction => 0,
      postmoderated           => 0,
      show_probability        => 100,
      skipnoud                => 0,
      dsp_types               => [0],
      ;
}

sub default_dsp_data {
    short_caption             => 'DSP Name',
      display_name            => 'DSP Display Name',
      url                     => 'http://dsp.ru/',
      test_url                => '',
      multistate              => 15,
      tag                     => 'sometag',
      data_key                => '',
      unmoderated_rtb_auction => 0,
      postmoderated           => 0,
      show_probability        => 100,
      skipnoud                => 0,
      dsp_types               => [0, 1, 2],
      dsp_formats             => [1],
      ;
}

1;
