package Test::Partner2::Fixture::DB::Dict;

use qbit;

use Test::Partner2::Fixture::DB::Utils;

sub get_fixtures {
    return (tns_dict_article(), tns_dict_brand(), picategories_dict());
}

sub tns_dict_article {
    return tns_dict_article => {
        deps => ['partner_db'],
        sub  => sub {
            my (%opts) = @_;

            my $pk = $opts{partner_db}->tns_dict_article->add_multi(
                [
                    {
                        sid  => 0,
                        grid => 0,
                        lev  => 0,
                        name => {en => 'MAIN GROUP', ru => 'ОСНОВНАЯ ГРУППА'},
                    },
                    {
                        sid  => 40,
                        grid => 0,
                        lev  => 2,
                        name => {
                            en => 'COMMUNICATIONS MEANS & EQUIPMENT',
                            ru => 'СРЕДСТВА СВЯЗИ И ОБОРУДОВАНИЕ'
                        },
                    },
                    {
                        sid  => 41,
                        grid => 0,
                        lev  => 2,
                        name => {
                            en => 'AUDIO, VIDEO, CINEMA & PHOTO EQUIPMENT',
                            ru => 'АУДИО, ВИДЕО, КИНО И ФОТОТЕХНИКА'
                        },
                    }
                ]
            );

            return $pk;
        },
    };
}

sub tns_dict_brand {
    return tns_dict_brand => {
        deps => ['partner_db'],
        sub  => sub {
            my (%opts) = @_;
            my $pk = $opts{partner_db}->tns_dict_brand->add_multi(
                [
                    {
                        bid     => 420,
                        name    => {en => 'COCA-COLA', ru => 'COCA-COLA'},
                        note    => '',
                        status  => 'A',
                        file_id => 1590,
                        hidden  => 0,
                    },
                    {
                        bid     => 647,
                        name    => {en => 'PEPSI', ru => 'PEPSI'},
                        note    => '',
                        status  => 'A',
                        file_id => 1590,
                        hidden  => 0,
                    }
                ]
            );
            return $pk;
        },
    };
}

sub picategories_dict {
    return picategories_dict => {
        deps => ['partner_db'],
        sub  => sub {
            my (%opts) = @_;

            my $pk = $opts{partner_db}->picategories_dict->add_multi(
                [
                    {
                        category_id => 0,
                        parent_id   => 0,
                        level       => 0,
                        name        => {en => 'MAIN GROUP', ru => 'ОСНОВНАЯ ГРУППА'},
                    },
                    {
                        category_id => 1,
                        parent_id   => 0,
                        level       => 1,
                        name        => {en => 'Automotive', ru => 'Автомобили и мотоциклы'},
                    },
                    {
                        category_id => 52,
                        parent_id   => 0,
                        level       => 1,
                        name        => {en => 'Business and Finance', ru => 'Бизнес и финансы'},
                    }
                ]
            );

            return $pk;
        },
    };
}

1;
