package Test::Partner2::Fixture::DB::Page;

use qbit;

use Test::Partner2::Fixture::DB::Utils;

sub get_fixtures {
    return (
        context_page_fixture(
            fixture_name => 'partner_context_page',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_page_with_unmoderated_rtb_auction',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',

            unmoderated_rtb_auction => 1
        ),
        context_page_fixture(
            fixture_name => 'partner_context_vip_page',

            vip => 1,

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_graysite_page',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_graysite_site',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_page_with_mirrors',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
            mirrors             => [
                {domain => 'mocked.partner.approved.mirror.ru',},
                {
                    domain     => 'mocked.partner.rejected.mirror.ru',
                    multistate => 2,
                },
                {
                    domain             => 'mocked.partner.new.mirror.ru',
                    multistate         => 0,
                    waiting_moderation => '2018-12-03 14:45:12',
                },
            ],
        ),
        context_page_fixture(
            fixture_name => 'adinside_context_page',

            owner_fixture_name  => 'user_adinside',
            source_fixture_name => 'partner_site',
        ),
        context_page_fixture(
            fixture_name => 'business_unit_context_page',

            owner_fixture_name  => 'user_business_unit',
            source_fixture_name => 'business_unit_site',
        ),
        mobile_page_fixture(
            fixture_name => 'partner_mobile_page',

            owner_fixture_name  => 'mocked_mobile_app_partner',
            source_fixture_name => 'partner_mobile_app',
        ),
        mobile_page_fixture(
            fixture_name => 'adinside_mobile_page',

            owner_fixture_name  => 'user_adinside',
            source_fixture_name => 'adinside_mobile_app',
        ),
        mobile_page_fixture(
            fixture_name => 'partner_mobile_page_simple_inapp',

            owner_fixture_name  => 'mocked_mobile_partner_with_simple_inapp',
            source_fixture_name => 'partner_mobile_app',
            picategories        => [{category_id => 52, cpm => 9999}],
        ),
        mobile_page_fixture(
            fixture_name => 'business_unit_mobile_page',

            owner_fixture_name  => 'user_business_unit',
            source_fixture_name => 'business_unit_mobile_app',
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page',

            owner_fixture_name => 'mocked_video_partner',

            domain     => 'mocked.video.site.ru',
            multistate => 1,
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_with_direct_vast_request',

            owner_fixture_name => 'mocked_video_partner',

            domain => 'mocked.direct.vast.request.video.site.ru',
            opts   => {allow_direct_vast_request => 1,},
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_with_vpaid_disabled',

            owner_fixture_name => 'mocked_video_partner',

            domain        => 'mocked.no.vpaid.video.site.ru',
            vpaid_enabled => 0,
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_p0',

            owner_fixture_name => 'mocked_video_partner',

            domain   => 'mocked.video.site.ru',
            platform => 0,
            title    => 'partner_video_page_p0',
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_p1',

            owner_fixture_name => 'mocked_video_partner',

            domain   => 'mocked.video.site.ru',
            platform => 1,
            title    => 'partner_video_page_p1',
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_p2',

            owner_fixture_name => 'mocked_video_partner',

            domain   => 'mocked.video.site.ru',
            platform => 2,
            title    => 'partner_video_page_p2',
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_p3',

            owner_fixture_name => 'mocked_video_partner',

            domain   => 'mocked.video.site.ru',
            platform => 3,
            title    => 'partner_video_page_p3',
        ),
        video_page_fixture(
            fixture_name => 'partner_video_page_vmap',

            owner_fixture_name => 'mocked_video_partner_with_vmap',

            domain => 'mocked.video.site.ru',
            title  => 'partner_video_page_vmap',
        ),
        indoor_page_fixture(
            fixture_name => 'partner_indoor_page',

            owner_fixture_name => 'mocked_indoor_partner',

            opts => {domain => 'mocked.indoor.video.site.ru',},
        ),
        indoor_page_fixture(
            fixture_name => 'partner_indoor_page_in_testmode',

            owner_fixture_name => 'mocked_indoor_partner',

            opts => {is_in_testmode => 1,},
        ),
        indoor_page_fixture(
            fixture_name => 'partner_indoor_page_assessor',

            owner_fixture_name => 'mocked_indoor_partner_assessor',

            opts => {domain => 'mocked.indoor.video.site.ru',},
        ),
        indoor_page_fixture(
            fixture_name => 'partner_indoor_page_in_testmode_assessor',

            owner_fixture_name => 'mocked_indoor_partner_assessor',

            opts => {is_in_testmode => 1,},
        ),
        indoor_page_fixture(
            fixture_name => 'partner_indoor_page_with_moderation',

            owner_fixture_name => 'mocked_indoor_partner',

            multistate => 1536,
            opts       => {
                caption          => 'changed InDoor page caption',
                caption_approved => 'approved InDoor page caption',
                address          => 'changed InDoor page address st., 97',
                address_approved => 'approved InDoor page address st., 97',
                gps              => '-87,85',
                gps_appproved    => '-85,87',
                moderation       => {
                    caption => {
                        'changed InDoor page caption'  => {verdict => 0, request_id => 111111},
                        'approved InDoor page caption' => {verdict => 1, request_id => 211111},
                    },
                    address => {
                        'changed InDoor page address st., 97'  => {verdict => 0, request_id => 111112},
                        'approved InDoor page address st., 95' => {verdict => 1, request_id => 211112},
                    },
                    gps => {
                        '-87,85' => {verdict => 0, request_id => 111113},
                        '-85,87' => {verdict => 1, request_id => 211113},
                    },
                },
            }
        ),
        indoor_page_fixture(
            fixture_name => 'partner_updated_indoor_page',

            owner_fixture_name => 'mocked_indoor_partner',

            update_time => '2019-08-20 15:50:00',
        ),

        outdoor_page_fixture(
            fixture_name => 'partner_outdoor_page',

            owner_fixture_name => 'mocked_outdoor_partner',

            opts => {domain => 'mocked.outdoor.video.site.ru',},
        ),
        outdoor_page_fixture(
            fixture_name => 'partner_outdoor_page_in_testmode',

            owner_fixture_name => 'mocked_outdoor_partner',

            opts => {is_in_testmode => 1,},
        ),
        outdoor_page_fixture(
            fixture_name => 'partner_updated_outdoor_page',

            owner_fixture_name => 'mocked_outdoor_partner',

            update_time => '2019-08-20 15:50:00',
        ),
        outdoor_page_fixture(
            fixture_name => 'partner_outdoor_page_with_moderation',

            owner_fixture_name => 'mocked_outdoor_partner',

            multistate => 1536,
            opts       => {
                caption          => 'changed OutDoor page caption',
                caption_approved => 'approved OutDoor page caption',
                moderation       => {
                    caption => {
                        'changed OutDoor page caption'  => {verdict => 0, request_id => 111111},
                        'approved OutDoor page caption' => {verdict => 1, request_id => 211111},
                    },
                },
            }
        ),
        outdoor_page_fixture(
            fixture_name => 'partner_outdoor_page_assessor',

            owner_fixture_name => 'mocked_outdoor_partner_assessor',
        ),
        outdoor_page_fixture(
            fixture_name => 'partner_outdoor_page_in_testmode_assessor',

            owner_fixture_name => 'mocked_outdoor_partner_assessor',

            opts => {is_in_testmode => 1,},
        ),

        internal_context_page_fixture(
            fixture_name => 'internal_context_page',

            managers_fixture_names => [qw(mocked_internal_manager)],

            creator_fixture_name => 'mocked_internal_administrator',

            source_fixture_name => 'internal_site',
        ),
        internal_mobile_page_fixture(
            fixture_name => 'internal_mobile_page',

            managers_fixture_names => [qw(mocked_internal_manager)],

            creator_fixture_name => 'mocked_internal_administrator',

            store_id => 'com.internal.mobile.app',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_page_with_video',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_page_with_rewarded',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
        ),
        context_page_fixture(
            fixture_name => 'partner_context_page_with_rewarded_only',

            owner_fixture_name  => 'mocked_yan_partner',
            source_fixture_name => 'partner_site',
        ),

        id_provider_fixture('campaign_id_provider'),
        id_provider_fixture('page_id_provider'),
        bk_language_fixture(),
    );
}

sub bk_language_fixture {
    return (
        bk_language => {
            deps => [qw(partner_db)],
            sub  => sub {
                my (%opts) = @_;

                my $pk = $opts{partner_db}->bk_language->add_multi(
                    [
                        {
                            id           => 1,
                            language     => 'ru',
                            display_name => {
                                en => 'Russian (ru)',
                                ru => 'Русский (ru)',
                            },
                        },
                        {
                            id           => 2,
                            language     => 'uk',
                            display_name => {
                                en => 'Ukrainian (uk)',
                                ru => 'Украинский (uk)',
                            },
                        },
                        {
                            id           => 3,
                            language     => 'en',
                            display_name => {
                                en => 'English (en)',
                                ru => 'Английский (en)',
                            },
                        },
                        {
                            id           => 4,
                            language     => 'by',
                            display_name => {
                                en => 'Belarusian (by)',
                                ru => 'Белорусский (by)',
                            },
                        },
                        {
                            id           => 5,
                            language     => 'kz',
                            display_name => {
                                en => 'Kazakh (kz)',
                                ru => 'Казахский',
                            },
                        },
                        {
                            id           => 6,
                            language     => 'tr',
                            display_name => {
                                en => 'Turkish (tr)',
                                ru => 'Турецкий (tr)',
                            },
                        },
                        {
                            id           => 7,
                            language     => 'tt',
                            display_name => {
                                en => 'Tatar (tt)',
                                ru => 'Татарский (tt)',
                            },
                        },
                    ]
                );

                return {id => $pk};
            },
        }
    );
}

sub context_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'context_on_site_campaign',
        page_id_field_name   => 'page_id',
        has_campaign_id      => 1,
        source_id_field_name => 'domain_id',
        defaults             => {default_context_page_data()},
        mirror_table_name    => 'context_on_site_mirrors',
    );
}

sub mobile_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'mobile_app_settings',
        page_id_field_name   => 'context_page_id',
        has_campaign_id      => 1,
        source_id_field_name => 'application_id',
        defaults             => {default_mobile_page_data()},
    );
}

sub video_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'video_an_site',
        page_id_field_name   => 'id',
        has_video_categories => 1,
        has_scenaries        => 1,
        defaults             => {default_video_page_data()},
    );
}

sub indoor_page_fixture {
    my (%page_data) = @_;

    $page_data{opts} = {%{$page_data{opts}}} if $page_data{opts};

    if (my $caption = delete $page_data{caption}) {
        $page_data{opts}{caption}          = $caption;
        $page_data{opts}{caption_approved} = $caption;
    }

    page_fixtures(
        %page_data,
        page_table_name    => 'indoor',
        page_id_field_name => 'page_id',
        has_campaign_id    => 1,
        defaults           => {default_indoor_page_data()},
    );
}

sub outdoor_page_fixture {
    my (%page_data) = @_;

    $page_data{opts} = {%{$page_data{opts}}} if $page_data{opts};

    if (my $caption = delete $page_data{caption}) {
        $page_data{opts}{caption}          = $caption;
        $page_data{opts}{caption_approved} = $caption;
    }

    page_fixtures(
        %page_data,
        page_table_name    => 'outdoor',
        page_id_field_name => 'page_id',
        has_campaign_id    => 1,
        defaults           => {default_outdoor_page_data()},
    );
}

sub internal_context_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'internal_context_on_site_campaign',
        page_id_field_name   => 'id',
        source_id_field_name => 'site_id',
        internal_owner       => 1,
        defaults             => {default_internal_context_page_data()},
    );
}

sub internal_mobile_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name    => 'internal_mobile_app',
        page_id_field_name => 'id',
        has_campaign_id    => 1,
        internal_owner     => 1,
        defaults           => {default_internal_mobile_page_data()},
    );
}

sub page_fixtures {
    my (%page_data) = @_;

    my (
        $fixture_name,        $owner_fixture_name,   $managers_fixture_names, $has_video_categories,
        $source_fixture_name, $page_table_name,      $page_id_field_name,     $source_id_field_name,
        $has_campaign_id,     $vip,                  $mirrors,                $mirror_table_name,
        $defaults,            $creator_fixture_name, $internal_owner,         $has_scenaries,
        $picategories
       )
      = delete @page_data{
        qw(
          fixture_name
          owner_fixture_name
          managers_fixture_names
          has_video_categories
          source_fixture_name
          page_table_name
          page_id_field_name
          source_id_field_name
          has_campaign_id
          vip
          mirrors
          mirror_table_name
          defaults
          creator_fixture_name
          internal_owner
          has_scenaries
          picategories
          )
      };

    my %manager_link_fixtures;
    if ($managers_fixture_names) {
        %manager_link_fixtures = manager_link_fixtures(
            fixture_name           => "${fixture_name}_managers",
            page_fixture_name      => $fixture_name,
            page_id_field_name     => $page_id_field_name,
            managers_fixture_names => $managers_fixture_names,
        );
    }

    my %video_categories_fixtures;
    if ($has_video_categories) {
        %video_categories_fixtures = video_categories_fixtures(
            fixture_name      => "${fixture_name}_categories",
            page_fixture_name => $fixture_name,
            page_source_name  => $page_data{domain} // $defaults->{domain},
        );
    }

    my %vip_list_fixtures;
    if ($vip) {
        %vip_list_fixtures = vip_list_fixtures(
            fixture_name       => "${fixture_name}_vip_list_entry",
            page_fixture_name  => $fixture_name,
            page_id_field_name => $page_id_field_name,
        );
    }

    my %mirror_fixtures;
    if ($mirrors) {
        %mirror_fixtures = map {
            mirror_fixtures(
                fixture_name      => "${fixture_name}_mirror_$_->{domain}",
                page_fixture_name => $fixture_name,
                mirror_table_name => $mirror_table_name,
                %$_
              )
        } @$mirrors;
    }

    my %scenaries_fixtures;
    if ($has_scenaries) {
        %scenaries_fixtures = scenaries_fixtures(
            fixture_name       => "${fixture_name}_video_scenaries",
            page_fixture_name  => $fixture_name,
            page_id_field_name => $page_id_field_name,
        );
    }

    my @dicts;
    my %picategories;
    if ($picategories) {
        push @dicts, 'picategories_dict';
        %picategories = picategories_page_fixtures(
            fixture_name      => "${fixture_name}_picategories_blocks",
            page_fixture_name => $fixture_name,
            picategories      => $picategories,
        );
    }

    return (
        $fixture_name => {
            deps => [
                qw(partner_db campaign_id_provider page_id_provider bk_language),
                $source_fixture_name  // (),
                $owner_fixture_name   // (),
                $creator_fixture_name // (),
                ($internal_owner ? 'user_adinside' : ()), @dicts
            ],
            validate_models => [$page_table_name],
            next            => [
                keys(%manager_link_fixtures), keys(%video_categories_fixtures),
                keys(%vip_list_fixtures),     keys(%mirror_fixtures),
                keys(%scenaries_fixtures),    keys(%picategories),
            ],
            sub => sub {
                my (%opts) = @_;

                my $page_id = $opts{page_id_provider}->();
                my %keys = ($has_campaign_id ? (id => $page_id) : (), $page_id_field_name => $page_id,);

                $creator_fixture_name //= $owner_fixture_name;

                my $pk = $opts{partner_db}->$page_table_name->add(
                    opts_to_json(
                        merge_db_hashes(
                            $defaults,
                            \%keys,
                            \%page_data,
                            $owner_fixture_name ? ({owner_id => $opts{$owner_fixture_name}->{id}}) : (),
                            {creator_id => $opts{$creator_fixture_name}->{id}},
                            $source_id_field_name
                            ? ({$source_id_field_name => $opts{$source_fixture_name}->{id}})
                            : (),
                        )
                    )
                );

                return \%keys;
            },
        },
        %manager_link_fixtures,
        %video_categories_fixtures,
        %vip_list_fixtures,
        %mirror_fixtures,
        %scenaries_fixtures,
        %picategories,
    );
}

sub manager_link_fixtures {
    my (%link_data) = @_;

    my ($fixture_name, $page_fixture_name, $page_id_field_name, $managers_fixture_names,) = delete @link_data{
        qw(
          fixture_name
          page_fixture_name
          page_id_field_name
          managers_fixture_names
          )
      };

    return $fixture_name => {
        deps => ['partner_db', $page_fixture_name, @$managers_fixture_names],
        sub  => sub {
            my (%opts) = @_;

            my $links =
              [map {{page_id => $opts{$page_fixture_name}{$page_id_field_name}, manager_id => $opts{$_}{id},}}
                  @$managers_fixture_names];
            $opts{partner_db}->managers->add_multi();

            return $links;
        },
    };
}

sub video_categories_fixtures {
    my (%page_data) = @_;

    my ($fixture_name, $page_fixture_name, $page_source_name) = delete @page_data{
        qw(
          fixture_name
          page_fixture_name
          page_source_name
          )
      };

    return $fixture_name => {
        deps => [$page_fixture_name, qw(app partner_db)],
        sub  => sub {
            my (%opts) = @_;

            my $categories =
              [map {$_->{page_id} = $opts{$page_fixture_name}{id}; $_}
                  @{$opts{app}->video_an_site_categories->get_default_video_categories($page_source_name)}];

            $opts{partner_db}->video_an_site_categories->add_multi($categories);

            return $categories;
        },
    };
}

sub vip_list_fixtures {
    my (%page_data) = @_;

    my ($fixture_name, $page_fixture_name, $page_id_field_name) = delete @page_data{
        qw(
          fixture_name
          page_fixture_name
          page_id_field_name
          )
      };

    return $fixture_name => {
        deps => ['partner_db', $page_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $entry = {page_id => $opts{$page_fixture_name}{$page_id_field_name}};
            $opts{partner_db}->vip->add($entry);

            return $entry;
        },
    };
}

sub mirror_fixtures {
    my (%mirror_data) = @_;

    my ($fixture_name, $page_fixture_name, $mirror_table_name, $mirror_fields_data) = delete @mirror_data{
        qw(
          fixture_name
          page_fixture_name
          mirror_table_name
          mirror_fields_data
          )
      };

    return $fixture_name => {
        deps => [$page_fixture_name, qw(app partner_db)],
        sub  => sub {
            my (%opts) = @_;

            my $pk = $opts{partner_db}->$mirror_table_name->add(
                {
                    default_mirror_data(),
                    campaign_id => $opts{$page_fixture_name}{id},
                    %mirror_data,
                }
            );

            return $pk;
        },
    };
}

sub scenaries_fixtures {
    my (%scenaries_data) = @_;

    my ($fixture_name, $page_fixture_name, $page_id) = delete @scenaries_data{
        qw(
          fixture_name
          page_fixture_name
          page_id_field_name
          )
      };

    return $fixture_name => {
        deps => [$page_fixture_name, qw(app partner_db)],
        sub  => sub {
            my (%opts) = @_;

            my $pk = $opts{partner_db}->video_scenaries->add(
                opts_to_json(
                    {
                        default_scenaries_data(),
                        page_id => $opts{$page_fixture_name}{$page_id},
                        %scenaries_data,
                    }
                )
            );

            return $pk;
        },
    };
}

sub default_context_page_data {
    return (
        'pi_id'                   => undef,
        'send_time'               => '1970-01-01 03:00:00',
        'unmoderated_rtb_auction' => '0',
        'behavioral_targeting'    => '1',
        'caption'                 => 'Mocked YAN Partner Page',
        'adblock'                 => '0',
        'reload_timeout'          => '30',
        'multistate'              => '0',
        'tier'                    => '3',
        'metrica_counters'        => '',
        'tag_id'                  => undef,
        'fast_context'            => '1',
        'update_time'             => '1970-01-01 03:00:00',
        'allowed_amp'             => '1',
        'market_api'              => '0',
        'family_filter'           => '0',
        'domain_id'               => '1',
        'performance_tgo_disable' => '0',
        'mobile_app_mode'         => '0',
        'user_synchronization'    => '0',
        'block_title'             => '',
        'create_date'             => '2018-10-04 20:37:23',
        'view_images'             => '1',
        'allowed_turbo'           => '1',
        'comment'                 => undef,
        'only_picture'            => '0',
        'page_lang'               => '1',
        'opts'                    => {
            'order_tags'  => [1, 5],
            'target_tags' => [1, 3, 5],
        }
    );
}

sub default_internal_context_page_data {
    return (
        'update_time'             => '1970-01-01 03:00:00',
        'send_time'               => '1970-01-01 03:00:00',
        'unmoderated_rtb_auction' => '0',
        'behavioral_targeting'    => '1',
        'family_filter'           => '0',
        'performance_tgo_disable' => '0',
        'mobile_app_mode'         => '0',
        'block_title'             => '',
        'view_images'             => '1',
        'create_date'             => '1970-01-01 03:00:00',
        'allowed_turbo'           => '1',
        'reload_timeout'          => '30',
        'multistate'              => '17',
        'tier'                    => '3',
        'comment'                 => '',
        'only_picture'            => '0',
        'page_lang'               => '1',
        'metrica_counters'        => '',
        'fast_context'            => '1',
        'opts'                    => {},
    );
}

sub default_mobile_page_data {
    return (
        'update_time'             => '1970-01-01 03:00:00',
        'send_time'               => '1970-01-01 03:00:00',
        'unmoderated_rtb_auction' => '0',
        'behavioral_targeting'    => '1',
        'family_filter'           => '0',
        'caption'                 => 'Mocked Mobile Page',
        'cpa'                     => undef,
        'performance_tgo_disable' => '0',
        'block_title'             => '',
        'view_images'             => '1',
        'create_date'             => '1970-01-01 03:00:00',
        'multistate'              => '33',
        'tier'                    => '3',
        'only_picture'            => '0',
        'comment'                 => undef,
        'false_click'             => '0',
        'fast_context'            => '1',

        'opts' => {is_mobile_mediation => 0,},
    );
}

sub default_internal_mobile_page_data {
    return (
        'update_time'             => '1970-01-01 03:00:00',
        'send_time'               => '1970-01-01 03:00:00',
        'unmoderated_rtb_auction' => '0',
        'behavioral_targeting'    => '1',
        'caption'                 => 'Mocked Internal Mobile Page',
        'family_filter'           => '0',
        'performance_tgo_disable' => '0',
        'block_title'             => '',
        'view_images'             => '1',
        'create_date'             => '1970-01-01 03:00:00',
        'multistate'              => '1',
        'opts'                    => {},
        'tier'                    => '3',
        'false_click'             => '0',
        'comment'                 => undef,
        'only_picture'            => '0',
        'type'                    => '1',
        'fast_context'            => '1'
    );
}

sub default_video_page_data {
    return (
        'wrapper_timeout'         => '2000',
        'update_time'             => '1970-01-01 03:00:00',
        'send_time'               => '1970-01-01 03:00:00',
        'skip_time_left_show'     => '0',
        'buffer_full_timeout'     => '2000',
        'unmoderated_rtb_auction' => '0',
        'vast_timeout'            => '2000',
        'buffer_empty_limit'      => '2',
        'caption'                 => 'Mocked Video Page',
        'vast_version'            => '2',
        'platform'                => '0',
        'video_timeout'           => '2000',
        'skin'                    => '',
        'user_synchronization'    => '0',
        'vpaid_enabled'           => '1',
        'create_date'             => '1970-01-01 03:00:00',
        'pixels'                  => undef,
        'multistate'              => '0',
        'vpaid_timeout'           => '2000',
        'tier'                    => '3',
        'skin_timeout'            => '2000',
        'time_left_show'          => '1',
        'comment'                 => undef,
        'title'                   => '',
        'owner_id'                => '5',
        'tag_id'                  => undef,
        'wrapper_max_count'       => '3',
        'partner_type'            => undef,
        'skip_delay'              => '5',
        'opts'                    => {
            'order_tags'  => [2, 4],
            'target_tags' => [1, 2, 4]
        }
    );
}

sub default_indoor_page_data {
    return (
        create_date => '1970-01-01 03:00:00',
        multistate  => 257 + 1024,
        update_time => '1970-01-01 03:00:00',
        send_time   => '1970-01-01 03:00:00',
        opts        => {
            caption          => 'Mocked InDoor Page',
            caption_approved => 'Mocked InDoor Page',
            domain           => 'mocked.indoor.page.ru',
            address          => 'TestAddress',
            address_approved => 'TestAddress',
            gps              => '-80,123',
            gps_approved     => '-80,123',
            facility_type    => 5,
        },
    );
}

sub default_outdoor_page_data {
    return (
        create_date => '1970-01-01 03:00:00',
        multistate  => 257 + 1024,
        update_time => '1970-01-01 03:00:00',
        send_time   => '1970-01-01 03:00:00',
        opts        => {
            caption          => 'Mocked OutDoor Page',
            caption_approved => 'Mocked OutDoor Page',
            domain           => 'mocked.outdoor.page.ru',
            facility_type    => 1,
        },
    );
}

sub default_mirror_data {
    return (
        create_date        => '1970-01-01 03:00:00',
        multistate         => 1,
        auto               => 0,
        waiting_moderation => '1000-01-01 00:00:00',
    );
}

sub search_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'search_on_site_campaign',
        page_id_field_name   => 'page_id',
        has_campaign_id      => 1,
        source_id_field_name => 'domain_id',
        defaults             => {default_search_page_data()},
        mirror_table_name    => 'search_on_site_mirrors',
    );
}

sub internal_search_page_fixture {
    my (%page_data) = @_;

    page_fixtures(
        %page_data,
        page_table_name      => 'internal_search_on_site_campaign',
        page_id_field_name   => 'id',
        source_id_field_name => 'site_id',
        internal_owner       => 1,
        defaults             => {default_internal_search_page_data()},
    );
}

sub default_search_page_data {
    return (
        'pi_id'                => undef,
        'send_time'            => '1970-01-01 03:00:00',
        'caption'              => 'Mocked YAN Partner Page',
        'reload_timeout'       => '30',
        'multistate'           => '0',
        'tier'                 => '3',
        'metrica_counters'     => '',
        'tag_id'               => undef,
        'update_time'          => '1970-01-01 03:00:00',
        'market_api'           => '0',
        'family_filter'        => '0',
        'domain_id'            => '1',
        'mobile_app_mode'      => '0',
        'user_synchronization' => '0',
        'block_title'          => '',
        'create_date'          => '2018-10-04 20:37:23',
        'comment'              => undef,
        'page_lang'            => '1',
    );
}

sub default_internal_search_page_data {
    return (
        'update_time'      => '1970-01-01 03:00:00',
        'send_time'        => '1970-01-01 03:00:00',
        'family_filter'    => '0',
        'mobile_app_mode'  => '0',
        'block_title'      => '',
        'create_date'      => '1970-01-01 03:00:00',
        'reload_timeout'   => '30',
        'multistate'       => '17',
        'tier'             => '3',
        'comment'          => '',
        'page_lang'        => '1',
        'metrica_counters' => ''
    );
}

sub default_scenaries_data {
    return (
        'id'          => 1,
        'caption'     => 'Default scenario',
        'create_date' => '1970-01-01 03:00:00',
        'multistate'  => '2',
        'opts'        => {'single_ad_session' => 0, 'use_better_places' => 0}
    );
}

sub picategories_page_fixtures {
    my (%data) = @_;

    my ($fixture_name, $picategories, $page_fixture_name) =
      delete @data{qw(fixture_name picategories page_fixture_name)};

    return $fixture_name => {
        deps => ['partner_db', 'picategories_dict', $page_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $filter  = $opts{$page_fixture_name};
            my $page_id = $filter->{id};
            $opts{partner_db}->picategories->add_multi(
                [
                    map +{
                        page_id     => $page_id,
                        block_id    => 0,
                        category_id => $_->{category_id},
                        cpm         => $_->{cpm},
                    },
                    @$picategories
                ],
                replace => 1
            );

            return;
        },
    };
}

1;
