package Test::Partner2::Fixture::DB::Source;

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Fixture::DB::Utils;

sub get_fixtures {
    return (
        site_fixture(
            fixture_name => 'partner_site',

            owner_fixture_names => ['mocked_yan_partner'],

            domain => 'partner.ru',
        ),
        site_fixture(
            fixture_name => 'adinside_site',

            owner_fixture_names => ['user_adinside'],

            domain => 'yandex.ru',
        ),
        site_fixture(
            fixture_name => 'business_unit_site',

            owner_fixture_names => ['user_business_unit'],

            domain => 'moviesearch.ru',
        ),
        site_fixture(
            fixture_name => 'partner_graysite_site',

            owner_fixture_names => ['mocked_yan_partner'],

            domain => 'partner.graysite.ru',

            is_graysite => 1,
        ),
        mobile_app_fixture(
            fixture_name => 'partner_mobile_app',

            owner_fixture_names => ['mocked_mobile_app_partner'],

            store_id => 'com.mocked.app',
        ),
        mobile_app_fixture(
            fixture_name => 'adinside_mobile_app',

            owner_fixture_names => ['user_adinside'],

            store_id => 'com.mocked.adinside.app',
        ),
        mobile_app_fixture(
            fixture_name => 'busniess_unit_mobile_app',

            owner_fixture_names => ['user_business_unit'],

            store_id => 'com.mocked.business.unit.app',
        ),
        mobile_app_fixture(
            fixture_name => 'adinside_mobile_app',

            owner_fixture_names => ['user_adinside'],

            store_id => 'com.mocked.adinside.app',
        ),
        mobile_app_fixture(
            fixture_name => 'business_unit_mobile_app',

            owner_fixture_names => ['user_business_unit'],

            store_id => 'com.mocked.business.unit.app',
        ),
        internal_site_fixture(
            fixture_name => 'internal_site',

            domain => 'mocked.yandex.ru',
        ),
    );
}

sub site_fixture {
    my (%site_data) = @_;

    source_fixtures(
        %site_data,
        source_table_name          => 'site',
        owner_table_name           => 'owner_site',
        owner_table_source_id_name => 'domain_id',
        defaults                   => {default_site_data()},
        owner_defaults             => {default_owner_site_data()},
    );
}

sub mobile_app_fixture {
    my (%mobile_app_data) = @_;

    source_fixtures(
        %mobile_app_data,
        source_table_name          => 'mobile_app',
        owner_table_name           => 'mobile_app_owner',
        owner_table_source_id_name => 'app_id',
        defaults                   => {default_mobile_app_data()},
        owner_defaults             => {},
    );
}

sub internal_site_fixture {
    my (%site_data) = @_;

    source_fixtures(
        %site_data,
        source_table_name => 'internal_site',
        defaults          => {},
    );
}

sub source_fixtures {
    my (%source_data) = @_;

    my ($fixture_name, $source_table_name, $owner_fixture_names, $owner_table_name, $owner_table_source_id_name,
        $defaults, $owner_defaults,)
      = delete @source_data{
        qw(
          fixture_name
          source_table_name
          owner_fixture_names
          owner_table_name
          owner_table_source_id_name
          defaults
          owner_defaults
          )
      };

    my %source_owner_fixtures;
    if ($owner_fixture_names || $defaults->{owner_fixture_names}) {
        my $default_owner_fixture_names = $defaults->{owner_fixture_names};
        my %source_owner_fixtures       = source_owner_fixtures(
            fixture_name        => "${fixture_name}_owners",
            source_fixture_name => $fixture_name,
            owner_fixture_names => $owner_fixture_names // $default_owner_fixture_names,
            table_name          => $owner_table_name,
            source_id_name      => $owner_table_source_id_name,
            defaults            => $owner_defaults,
        );
    }

    return (
        $fixture_name => {
            deps            => [qw(partner_db)],
            validate_models => [$source_table_name],
            next            => [keys(%source_owner_fixtures)],
            sub             => sub {
                my (%opts) = @_;

                my $pk =
                  $opts{partner_db}->$source_table_name->add(opts_to_json(merge_db_hashes($defaults, \%source_data)));

                return pk_to_hash($opts{partner_db}->$source_table_name, $pk);
            },
        },
        %source_owner_fixtures,
    );
}

sub source_owner_fixtures {
    my (%link_data) = @_;

    my ($fixture_name, $source_fixture_name, $owner_fixture_names, $table_name, $source_id_name, $defaults) =
      delete @link_data{
        qw(
          fixture_name
          source_fixture_name
          owner_fixture_names
          table_name
          source_id_name
          defaults
          )
      };

    return $fixture_name => {
        deps => [qw(partner_db), @$owner_fixture_names, $source_fixture_name],
        sub  => sub {
            my (%opts) = @_;

            my $owners = [
                map {
                    {
                        %$defaults,
                          $source_id_name => $opts{$source_fixture_name}{id},
                          user_id         => $opts{$_}{id},
                    }
                  } @$owner_fixture_names
            ];

            $opts{partner_db}->$table_name->add_multi($owners);

            return $owners;
        },
    };
}

sub default_site_data {
    multistate           => 4,
      create_date        => '2018-10-04 20:37:23',
      is_graysite        => 0,
      waiting_moderation => '1000-01-01 00:00:00',
      ;
}

sub default_owner_site_data {
    create_date => '2018-10-04 20:37:23',
      ;
}

sub default_mobile_app_data {
    multistate    => 4,
      type        => 1,
      create_date => '2018-10-04 20:37:23',
      store_url   => 'https://play.google.com',
      comment     => '',
      opts        => {is_mobile_mediation => 0,},
      ;
}

1;
