package Test::Partner2::Fixture::DB::StatReportParamsDigest;

use qbit;

use Test::Partner2::Fixture::DB::Utils;

my $PARAMS = to_json(
    {
        "isLevelsDifferent"  => JSON::XS::true,
        "tableViewModelData" => {"sortOrder" => "asc", "sortBy" => "rtb_partner_wo_nds"},
        "tableLevel"         => [
            {
                "levels"           => [{"filter" => undef, "id" => "payment"}],
                "dimension_filter" => undef,
                "vat"              => -1,
                "entity_fields"    => [],
                "period"           => ["2017-01-09",     "2018-01-06"],
                "order_by"         => [],
                "dimension_fields" => ["currency_id"],
                "total"            => 0,
                "fields"           => ["partner_wo_nds", "rtb_partner_wo_nds"]
            }
        ],
        "chartLevel" => [
            {
                "levels"           => [{"filter" => undef, "id" => "payment"}],
                "dimension_filter" => undef,
                "vat"              => -1,
                "entity_fields"    => [],
                "period"   => ["2017-01-09", "2018-01-06"],
                "top_keys" => 7,
                "order_by" =>
                  [{"field" => "partner_wo_nds", "dir" => "asc"}, {"field" => "rtb_partner_wo_nds", "dir" => "asc"}],
                "dimension_fields" => ["date|day",       "currency_id"],
                "total"            => 0,
                "fields"           => ["partner_wo_nds", "rtb_partner_wo_nds"]
            }
        ]
    }
);

sub get_fixtures {
    return (
        id_provider_fixture('stat_report_params_digest_id_provider'),
        stat_report_params_digest_fixtures(
            fixture_name => 'stat_report_params_digest_new',

            update_date => curdate(oformat => 'db_time'),
        ),
        stat_report_params_digest_fixtures(
            fixture_name => 'stat_report_params_digest_to_clean',

            update_date => '2018-09-23 12:56:34',
        ),
    );
}

sub stat_report_params_digest_fixtures {
    my (%data) = @_;

    my ($fixture_name, $update_date) = delete @data{
        qw(
          fixture_name
          update_date
          )
      };

    return (
        $fixture_name => {
            deps            => ['partner_db', 'stat_report_params_digest_id_provider'],
            validate_models => ['stat_report_params_digest'],
            next            => [],
            sub             => sub {
                my (%opts) = @_;

                my $pk = $opts{'partner_db'}->stat_report_params_digest->add(
                    {
                        id          => $opts{'stat_report_params_digest_id_provider'}->(),
                        params      => $PARAMS,
                        update_date => $update_date,
                    }
                );

                return pk_to_hash($opts{'partner_db'}->stat_report_params_digest, $pk);
            },
        },
    );
}

TRUE;
