package Test::Partner2::Fixture::DB::User;

use strict;
use warnings FATAL => 'all';
use qbit;
use Test::Partner2::Fixture::DB::Utils;

use PiConstants qw(:ROLES);

sub get_fixtures {
    return (
        id_provider_fixture('uid_provider'),
        id_provider_fixture('client_id_provider'),
        id_provider_fixture('adfox_id_provider'),

        user_fixtures(
            fixture_name => 'user_cron',

            login        => 'cron',
            domain_login => 'cron',
            id           => 0,
        ),
        user_fixtures(
            fixture_name => 'user_yndx_bessarabov',

            login => 'yndx-bessarabov',

            roles => [$DEVELOPER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_yan_partner',

            login => 'mocked-yan-partner',

            features => [],

            adfox_links => ['adfox_partner'],
        ),
        user_fixtures(
            fixture_name => 'mocked_mobile_app_partner',

            login => 'mocked-mobile-app-partner',

            roles => [$MOBILE_PARTNER_ROLE_ID],

            adfox_links => ['adfox_partner'],
        ),
        user_fixtures(
            fixture_name => 'mocked_video_partner',

            login => 'mocked-video-partner',

            roles => [$VIDEO_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_video_partner_with_vmap',

            login => 'mocked-video-partner-w-vmap',

            roles => [$VIDEO_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_indoor_partner',

            login => 'mocked-indoor-partner',

            roles => [$INDOOR_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_outdoor_partner',

            login => 'mocked-outdoor-partner',

            roles => [$OUTDOOR_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_yan_manager',

            login => 'mocked-yan-manager',

            roles => [$YAN_MANAGER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_dsp_manager',

            login => 'mocked-dsp-manager',

            roles => [$DSP_MANAGER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_dsp_partner',

            login => 'mocked-dsp-partner',

            roles => [$DSP_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'user_adinside',

            login                       => 'adinside',
            'accountant_email'          => undef,
            'newsletter'                => '1',
            'multistate'                => '1',
            'country_id'                => '225',
            'business_unit'             => '0',
            'no_stat_monitoring_emails' => '0',
            'is_tutby'                  => '0',
            'create_date'               => '1970-01-01 03:00:00',
            'need_to_email_processing'  => '0',
            'block_light_form_enabled'  => '0',
            'is_mobile_mediation'       => '0',
            'opts'                      => {
                'has_rsya'             => '1',
                'has_common_offer'     => '0',
                'has_mobile_mediation' => '0',
                'has_approved'         => '1',
                'has_tutby_agreement'  => '0',
            },

            mock_id_callback => sub {
                $PiConstants::ADINSIDE_USER_ID   = $_[0]->{id};
                $PiConstants::ADINSIDE_CLIENT_ID = $_[0]->{client_id};
            },

            features => [],
            roles    => [$SITE_PARTNER_ROLE_ID, $VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'user_business_unit',

            login         => 'mocked-business-unit',
            business_unit => '1',

            features => [],

            roles => [$SITE_PARTNER_ROLE_ID, $VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_internal_manager',

            login => 'mocked-internal-manager',

            roles => [$INTERNAL_YAN_MANAGER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_internal_administrator',

            login => 'mocked-internal-administrator',

            roles => [$INTERNAL_YAN_ADMINISTRATOR_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_indoor_partner_assessor',

            login => 'mocked-indoor-partner-assessor',

            roles => [$INDOOR_PARTNER_ROLE_ID, $ASSESSOR_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_outdoor_partner_assessor',

            login => 'mocked-outdoor-partner-assessor',

            roles => [$OUTDOOR_PARTNER_ROLE_ID, $ASSESSOR_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_yan_partner_games',

            login => 'mocked-yan-partner-games',

            'is_games' => '1',
        ),
        user_fixtures(
            fixture_name => 'mocked_developer',

            login => 'mocked-developer',

            roles => [$DEVELOPER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_developer',

            login => 'mocked-developer',

            roles => [$MOBILE_PARTNER_ROLE_ID],
        ),
        user_fixtures(
            fixture_name => 'mocked_mobile_partner_with_simple_inapp',

            login => 'mocked-mobile-partner-simple_inapp',

            roles => [$MOBILE_PARTNER_ROLE_ID],
        ),
    );
}

sub user_fixtures {
    my (%user_data) = @_;

    my ($fixture_name, $roles, $features, $adfox_links, $login, $mock_id_callback, $id) =
      delete @user_data{qw(fixture_name roles features adfox_links login mock_id_callback id)};

    my $defaults = {default_user_data()};

    my %adfox_link_fixtures = map {
        adfox_link_fixture(
            fixture_name      => "${fixture_name}_adfox_link_$_",
            user_fixture_name => $fixture_name,
            adfox_login       => $_,
          )
    } @{$adfox_links // []};

    my $default_roles = delete($defaults->{roles});
    my %role_fixtures = role_fixtures(
        fixture_name      => "${fixture_name}_roles",
        user_fixture_name => $fixture_name,
        roles             => $roles // $default_roles,
    );

    my %feature_fixtures = feature_fixtures(
        fixture_name      => "${fixture_name}_features",
        user_fixture_name => $fixture_name,
        features          => $features // [],
    );

    return (
        $fixture_name => {
            deps            => [qw(partner_db client_id_provider uid_provider)],
            next            => [keys(%role_fixtures), keys(%adfox_link_fixtures), keys(%feature_fixtures)],
            validate_models => [qw(users)],
            sub             => sub {
                my (%opts) = @_;

                my %keys = (
                    id => $id // $opts{uid_provider}->(),
                    client_id => $opts{client_id_provider}->(),
                    login     => $login,
                );

                my $pk = $opts{partner_db}->users->add(opts_to_json(merge_db_hashes($defaults, \%user_data, \%keys,)));

                $mock_id_callback->({%keys, partner_db => $opts{partner_db}}) if defined($mock_id_callback);

                return \%keys;
            },
        },
        %adfox_link_fixtures,
        %role_fixtures,
        %feature_fixtures,
    );
}

sub adfox_link_fixture {
    my (%link_data) = @_;

    my ($fixture_name, $user_fixture_name, $adfox_login) =
      delete @link_data{qw(fixture_name user_fixture_name adfox_login)};

    return $fixture_name => {
        deps => ['partner_db', $user_fixture_name, 'adfox_id_provider'],
        sub  => sub {
            my (%opts)        = @_;
            my $adfox_user_id = $opts{adfox_id_provider}->();
            my $keys          = {
                user_id     => $opts{$user_fixture_name}{id},
                adfox_id    => $adfox_user_id,
                adfox_login => $adfox_login,
            };
            $opts{partner_db}->user_adfox->add($keys);
            return $keys;
        },
      },
      ;
}

sub feature_fixtures {
    my (%feature_data) = @_;

    my ($fixture_name, $user_fixture_name, $features) =
      delete @feature_data{qw(fixture_name user_fixture_name features)};

    return $fixture_name => {
        deps => [qw(partner_db user_features_id_provider), $user_fixture_name],
        sub  => sub {
            my (%opts) = @_;
            my $features = [
                map {
                    {
                        id      => $opts{'user_features_id_provider'}->(),
                        user_id => $opts{$user_fixture_name}{id},
                        feature => $_,
                    }
                  } @$features
            ];
            $opts{partner_db}->user_features->add_multi($features);
            return $features;
        },
      },
      ;
}

sub role_fixtures {
    my (%role_data) = @_;

    my ($fixture_name, $user_fixture_name, $roles) = delete @role_data{qw(fixture_name user_fixture_name roles)};

    return $fixture_name => {
        deps => ['partner_db', $user_fixture_name],
        sub  => sub {
            my (%opts) = @_;
            my $roles = [map {{user_id => $opts{$user_fixture_name}{id}, role_id => $_,}} @$roles];
            $opts{partner_db}->user_role->add_multi($roles);
            return $roles;
        },
      },
      ;
}

sub default_user_data {
    # General
    'name'               => 'name',
      'midname'          => 'midname',
      'lastname'         => 'lastname',
      'email'            => 'mocked-email@ya.ru',
      'accountant_email' => 'mocked-accountant-email@ya.ru',
      'phone'            => '+799912312312',
      'country_id'       => 225,
      'create_date'      => '1970-01-01 03:00:00',
      # Flags
      'is_tutby'                  => '0',
      'is_mobile_mediation'       => '0',
      'business_unit'             => '0',
      'no_stat_monitoring_emails' => '0',
      'multistate'                => '0',
      'need_to_email_processing'  => '0',
      'newsletter'                => '0',
      'block_light_form_enabled'  => '0',
      'opts'                      => {
        'has_rsya'             => '1',
        'has_common_offer'     => '0',
        'has_mobile_mediation' => '0',
        'has_approved'         => '0',
        'has_tutby_agreement'  => '0',
      },
      'roles' => [$SITE_PARTNER_ROLE_ID],
      ;
}

1;
