package Test::Partner2::Fixture::DB::UserFeatures;

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Fixture::DB::Utils;

sub get_fixtures {
    id_provider_fixture('user_features_id_provider'),
      id_provider_fixture('user_features_id_provider'), user_features_fixtures(
        fixture_name => 'feature_vmap_for_mocked_video_partner',

        user_fixture_name => 'mocked_video_partner_with_vmap',

        feature => 'instream_vmap',
      ),
      user_features_fixtures(
        fixture_name => 'feature_simple_inapp_for_mocked_mobile_partner',

        user_fixture_name => 'mocked_mobile_partner_with_simple_inapp',

        feature => 'simple_inapp',
      ),
      ;
}

sub user_features_fixtures {
    my (%user_features_data) = @_;

    my ($fixture_name, $user_fixture_name, $feature) =
      delete @user_features_data{qw(fixture_name user_fixture_name feature)};

    return (
        $fixture_name => {
            deps            => [qw(partner_db user_features_id_provider), $user_fixture_name],
            next            => [],
            validate_models => [],
            sub             => sub {
                my (%opts) = @_;

                my %keys = (id => $opts{'user_features_id_provider'}->(),);

                $opts{partner_db}->user_features->add(
                    {
                        %keys,
                        user_id => $opts{$user_fixture_name}->{'id'},
                        feature => $feature,
                    }
                );

                return \%keys;
            },
        },
    );
}

1;
