package Test::Partner2::Fixture::DB::Utils;

use qbit;

use base qw(Exporter);
our @EXPORT_OK = qw(
  id_provider_fixture
  merge_db_hashes
  opts_to_json
  pk_to_hash
  );
our @EXPORT = @EXPORT_OK;

sub pk_to_hash {
    my ($table, $pk) = @_;

    $pk = [$pk] unless ref($pk) eq 'ARRAY';
    my $pk_names = $table->primary_key;

    return {map {$pk_names->[$_] => $pk->[$_]} (0 .. $#$pk)};
}

sub merge_db_hashes {
    my (@hashes) = @_;

    my $hash = shift @hashes;

    for my $one_more_hash (@hashes) {
        my $opts = delete $one_more_hash->{opts};
        if (defined($opts)) {
            $hash->{opts} = {%{$hash->{opts} // {}}, %$opts};
        }
        $hash = {%$hash, %$one_more_hash};
    }

    return $hash;
}

sub opts_to_json {
    my ($row) = @_;

    $row->{opts} = to_json($row->{opts}) if exists($row->{opts});

    return $row;
}

sub id_provider_fixture {
    my ($name) = @_;
    return $name => {
        sub => sub {
            my $id = 0;
            sub {
                ++$id;
            };
        },
    };
}

1;
