package Test::Partner2::Simple::More;

=encoding UTF-8

=head1 DESCRIPTION

Пример теста с использованием этой библиотеки:

    use Test::More;
    use Test::Partner2::Simple::More (app => 'Application', user => 123, rights => [aaa, bbb], mock_bk => 1);

    $app->...

    ...

    done_testing();

По умолчанию код запускается со всеми правами.

Опции:

  * user => 123 (быть этим пользователем (права итд), исключает 'rights')
  * rights => [] (взять эти права, а не все, исключает 'user')
  * mock_bk => 1 (замокать БК)
  * mock_now => '2015-01-01' (зафиксировать дату)
  * locale => 'C' (ru, en, C)
  * self => 'Application' (использовать асессор self для доступа к методам класса)


=cut

use qbit;
use Carp;
use Application;
use Rosetta;
use IntAPI;
use Cron;
use Test::Partner2::Database;
use Test::Partner2::Mock;
use Exporter;

our $app;
our $app_varname;
our %opts;
our $application_package;

sub import {
    my ($class, @params) = @_;
    my %params = @params;

    # get known params
    $opts{$_} = delete $params{$_} foreach (qw(user rights mock_bk mock_now locale));

    # get param: app accessor
    foreach my $k (keys(%params)) {
        my $v = $params{$k};
        if (in_array($v, ['Application', 'Cron']) && $k =~ /^\w+$/i) {
            # $app_package = $v;
            $opts{application_package} = $v;
            $app_varname = $k;
            delete $params{$k};
        }
    }

    # other params:
    if (keys(%params)) {
        ldump \%params;
        die "Unknown (bad) parameters";
    }

    # defs:
    $app_varname ||= 'app';

    # create $app
    _update_app();

    # ecport $app
    no strict 'refs';
    *{"main::$app_varname"} = *Test::Partner2::Simple::More::app;
}

sub _update_app {
    $application_package = $opts{'application_package'} // 'Application';

    $app = $application_package->new();
    $app->pre_run();

    our $tmp_rights;

    unless ($opts{'dont_create_database'}) {
        create_mocked_databases(app => $app);

        if ($opts{'mock_bk'}) {
            mock_bk($app);
        }

        if ($opts{'mock_now'}) {
            # TODO
            die "not implemented";
        }

        if ($opts{'locale'}) {
            die "Unknown locale" unless in_array($opts{'locale'}, [qw(en ru C)]);
            # TODO: if ('C') {override gettext() (just append prefix or capitalize) to check translates; }
            set_locale(
                project => $app->get_option('locale_domain', 'application'),
                path    => $app->get_option('ApplicationPath') . '/locale',
                lang    => $opts{'locale'},
            );
        }

        if ($opts{'user'}) {

            my $user = $app->partner_db->_get_all('select * from users where login = ? limit 3', $opts{'user'});
            croak sprintf("User with login '%s' not found", $opts{'user'}) unless @{$user} == 1;

            my $user_id = $user->[0]->{'id'};

            my @roles =
              map {$_->{'role_id'}}
              @{$app->partner_db->_get_all('select role_id from user_role where user_id = ?;', $user_id,)};

            my $u = {
                client_id  => $user->[0]->{'client_id'},
                id         => $user_id,
                multistate => $user->[0]->{'multistate'},
                name       => $user->[0]->{'name'},
                login      => $user->[0]->{'login'},
                email      => $user->[0]->{'email'},
                roles      => \@roles,
            };

            $app->set_cur_user($u);
        } else {

            my @rights;

            if (ref($opts{rights}) eq 'ARRAY') {
                @rights = (@{$opts{rights}}, 'users_view', 'users_view_all');
            } else {
                @rights = keys %{$app->get_registred_rights()};
            }

            $tmp_rights = $app->add_tmp_rights(@rights);

            my $user_id = 155209804;    # yndx.bessarabov

            my $user = $app->users->get(
                $user_id,
                fields => [
                    qw(
                      client_id
                      id
                      multistate
                      name
                      roles

                      )
                ],
            );

            $app->set_cur_user($user);
        }
    }

    $app;
}

DESTROY {
    $app->post_run() if ref($app);
}

TRUE;
