package Test::Partner2::Statistics::Data;

use strict;
use warnings;

use PiConstants qw(:ROLES :ROLES_GROUPS);
use Test::Deep qw(re ignore);

use qbit;

use Exporter qw(import);
our @EXPORT = qw(
  %currencies
  $dimension_field_date
  $dimension_field_currency_id
  $dimension_field_public_id
  $dimension_field_internal_mobile_block_type_label
  $dimension_field_dsp
  @common_fields
  $entity_field_login
  $entity_filter_field_role_id
  $entity_filter_field_user
  $entity_filter_field_managers
  $entity_filter_field_contract_tag
  $fields_dsp
  $fields_internal_advnet_context_on_site_page
  $fields_internal_advnet_context_on_site_content
  $fields_internal_advnet_context_on_site_direct
  $fields_internal_advnet_context_on_site_rtb
  $fields_internal_mobile_app_rtb
  $fields_internal_advnet_context_on_site_stripe
  $fields_internal_advnet_search_on_site_page
  $fields_internal_advnet_search_on_site_direct
  $fields_internal_advnet_search_on_site_premium
  $fields_internal_advnet_context_on_site_natural
  $fields_advnet_search_on_site_page
  $fields_advnet_context_on_site_stripe
  $fields_advnet_context_on_site_direct
  $fields_advnet_context_on_site_rtb
  $fields_advnet_context_on_site_page
  $fields_video_an_site_instream_publisher
  $fields_video_an_site_inpage_publisher
  $common_filter_fields
  );

my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);

our $dimension_field_date = {
    'type' => 'select',
    'values' =>
      [['day', 'Group by day'], ['week', 'Group by week'], ['month', 'Group by month'], ['year', 'Group by year']],
    'title' => 'Period',
    'id'    => 'date'
};

our $dimension_field_currency_id = {
    id            => 'currency_id',
    title         => 'currency',
    verbatim      => TRUE,
    type          => 'dictionary',
    filter_values => [
        sort {$a->{'label'} cmp $b->{'label'}}
        map {{'id' => $_, 'label' => $currencies{$_}, 'key' => "id$_"}} keys(%currencies)
    ],
};

our $dimension_field_public_id = {
    id         => 'public_id',
    title      => 'Block&nbsp;ID',
    type       => 'public_id',
    only_group => 1,
};

our $dimension_field_internal_mobile_block_type_label = {
    id         => 'internal_mobile_block_type_label',
    title      => 'Block type',
    verbatim   => TRUE,
    type       => 'dictionary',
    sort_as    => 'text',
    only_group => 1,
};

our $dimension_field_dsp = [
    {
        'sort_as'  => 'number',
        'ajax'     => 1,
        'verbatim' => 1,
        'type'     => 'dictionary',
        'title'    => re(qr(\w)),
        'id'       => 'page_id'
    },
    {
        'sort_as'  => 'text',
        'ajax'     => 1,
        'verbatim' => 1,
        'type'     => 'dictionary',
        'title'    => re(qr(\w)),
        'id'       => 'campaign'
    },
    {
        'type'       => 'boolean',
        'title'      => re(qr(\w)),
        'id'         => 'is_internal_campaign',
        'only_group' => 1,
    },
];

our @common_fields = ($dimension_field_date, $dimension_field_currency_id);

my $roles = [
    {id => $DEVELOPER_ROLE_ID},
    {id => $INTERNAL_YAN_MANAGER_ROLE_ID},
    {id => $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID},
    {id => $DSP_PARTNER_ROLE_ID},
    {id => $DSP_MANAGER_ROLE_ID},
    {id => $SITE_PARTNER_ROLE_ID},
    {id => $YAN_MANAGER_ROLE_ID},
    {id => $YAN_MODERATOR_ROLE_ID},
    {id => $YAN_VIEWER_ROLE_ID},
    {id => $DSP_VIEWER_ROLE_ID},
    {id => $INTERNAL_YAN_VIEWER_ROLE_ID},
    {id => $VIDEO_PARTNER_ROLE_ID},
    {id => $MOBILE_PARTNER_ROLE_ID},
    {id => $BUSINESS_UNIT_ROLE_ID},
    {id => $ADBLOCK_PARTNER_ROLE_ID},
    {id => $YAN_PARTNER_ASSISTANT_ROLE_ID},
    {id => $TUTBY_ROLE_ID},
    {id => $INDOOR_PARTNER_ROLE_ID},
    {id => $ADFOX_ROLE_ID},
    {id => $OUTDOOR_PARTNER_ROLE_ID},
    {id => $ROBOT_ASSISTANT_ROLE_ID},
    {id => $ASSESSOR_ROLE_ID},
];

our $entity_field_login = {
    'type'       => 'login',
    'label'      => re(qr(\w)),
    'id'         => 'login',
    'only_group' => 1,
};
our $entity_filter_field_role_id = {
    'values' => [map {{'label' => ignore(), 'id' => $_->{'id'}, 'key' => "id$_->{'id'}",}} @$roles],
    'label'  => 'Roles',
    'type'   => 'dictionary'
};
our $entity_filter_field_user = {
    'accountant_email'    => {'label' => re(qr(\w)), 'type'  => 'text'},
    'adfox_id'            => {'label' => re(qr(\w)), 'type'  => 'number'},
    'business_unit'       => {'type'  => 'boolean',},
    'client_id'           => {'label' => re(qr(\w)), 'type'  => 'number'},
    'contract_id'         => {'label' => re(qr(\w)), 'type'  => 'contractnumber'},
    'current_currency'    => {'type'  => 'text'},
    'domain_login'        => {'label' => re(qr(\w)), 'type'  => 'text'},
    'email'               => {'label' => re(qr(\w)), 'type'  => 'text'},
    'has_business_rule'   => {'type'  => 'boolean',  'label' => ignore(),},
    'has_common_offer'    => {'type'  => 'boolean'},
    'has_tutby_agreement' => {'type'  => 'boolean'},
    'id'                  => {'label' => re(qr(\w)), 'type'  => 'number'},
    'is_adfox_partner'    => {'type'  => 'boolean'},
    'is_tutby'            => {'type'  => 'boolean'},
    'is_yandex'           => {'type'  => 'boolean',},
    'lastname'            => {'label' => re(qr(\w)), 'type'  => 'text'},
    'login'               => {'label' => re(qr(\w)), 'type'  => 'login'},
    'moderation_reason'   => {
        'label'  => re(qr(\w)),
        'type'   => 'dictionary',
        'values' => [
            {
                'id'    => '1',
                'key'   => 'id1',
                'label' => re(qr(\w)),
            },
        ],
    },
    'multistate' => {
        'values' => {
            'contacts_provided'           => re(qr(\w)),
            'blocked'                     => re(qr(\w)),
            'need_create_in_banner_store' => re(qr(\w)),
            'need_yan_contract'           => re(qr(\w)),
        },
        'label' => re(qr(\w)),
        'type'  => 'multistate'
    },
    'name'                      => {'label' => re(qr(\w)), 'type' => 'text'},
    'need_to_email_processing'  => {'type'  => 'boolean'},
    'newsletter'                => {'type'  => 'boolean'},
    'no_stat_monitoring_emails' => {'type'  => 'boolean'},
    'phone'                     => {'label' => re(qr(\w)), 'type' => 'text'},
    'role_id'                   => $entity_filter_field_role_id,
    'self_employed' => {'type' => 'text'},
    'user_type'     => {
        'label'  => re(qr(\w)),
        'type'   => 'dictionary',
        'values' => [
            {'id' => 1, 'key' => 'id1', 'label' => re(qr(\w)),},
            {'id' => 2, 'key' => 'id2', 'label' => re(qr(\w)),},
            {'id' => 3, 'key' => 'id3', 'label' => re(qr(\w)),},
            {'id' => 4, 'key' => 'id4', 'label' => re(qr(\w)),},
            {'id' => 5, 'key' => 'id5', 'label' => re(qr(\w)),},
            {'id' => 6, 'key' => 'id6', 'label' => re(qr(\w)),},
        ],
    },
};

our $entity_filter_field_managers = {
    'subfields' => {
        'manager_id' => {'label' => re(qr(\w)), 'type' => 'number'},
        'manager'    => {
            'subfields' => $entity_filter_field_user,
            'label'     => re(qr(\w)),
            'type'      => 'subfilter'
        },
        'page_id' => {'label' => re(qr(\w)), 'type' => 'number'}
    },
    'label' => re(qr(\w)),
    'type'  => 'subfilter'
};
our $entity_filter_field_contract_tag = {
    id         => {type => 'number',     label => re(qr(\w))},
    multistate => {type => 'multistate', label => re(qr(\w)), values => {}},
    caption    => {type => 'text',       label => re(qr(\w))},
    comment    => {type => 'text',       label => re(qr(\w))},
    user_id    => {type => 'number',     label => re(qr(\w))},
    owner => {
        'subfields' => $entity_filter_field_user,
        'label'     => re(qr(\w)),
        'type'      => 'subfilter'
    },
};

our $fields_dsp = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'dsp_bids',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'dsp_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'all_hits',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'dsp_cpm_charging_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'dsp_cpm_charging_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'dsp_charging_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'dsp_charging_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'all_real_price_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'all_real_price_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'average_rate_all_real_price_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'average_rate_all_real_price_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    }
];

our $fields_internal_advnet_context_on_site_page = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_fraud_shows',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_fraud_clicks',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_direct_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_market_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_mcb_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_senthits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_senthits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_direct_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_page_ad_shows',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_ads',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpmh_direct_context_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        conflicts     => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpmh_direct_context_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        conflicts     => {dimension_fields => ['public_id', 'adfox_block']},
    },
];

our $fields_internal_advnet_context_on_site_direct = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_ctr',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_direct_context_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_direct_context_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_direct_context_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_direct_context_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
];

our $fields_internal_advnet_context_on_site_rtb = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_shows_own_adv',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_hits',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_hits_own_adv',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_hits_unsold',
        'category' => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_winrate',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_visibility',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'id'       => 'rtb_block_all_hits',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'category' => ignore(),
    },
    {
        'id'       => 'rtb_block_cover_ratio',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_shows',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_shows_own_adv',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_win_hits',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_win_hits_own_adv',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_win_hits_unsold',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_shows_percent',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_bad_win_hits_percent',
        'category' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_bad_win_price_w_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_bad_win_price_wo_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'percent',
        'title'       => re(qr(\w)),
        'id'          => 'percent_rtb_bad_win_price_rtb_all_w_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'percent',
        'title'       => re(qr(\w)),
        'id'          => 'percent_rtb_bad_win_price_rtb_all_wo_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_clicks',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_shows',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_ctr',
        'category' => re(qr(\w)),
    },
];

our $fields_internal_mobile_app_rtb = [
    {
        'hint'     => re(qr(\w)),
        'category' => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_shows',
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'category' => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_shows_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_hits',
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'category' => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_hits_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_hits_unsold'
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_rpm_all_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_block_rpm_all_wo_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_all_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_all_wo_nds',
        'short_title' => re(qr(\w)),
        'section'     => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_winrate',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_visibility',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'id'       => 'mobile_rtb_block_all_hits',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'category' => ignore(),
    },
    {
        'id'       => 'mobile_rtb_block_cover_ratio',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_shows',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_shows_own_adv',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_win_hits',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_win_hits_own_adv',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_win_hits_unsold',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_shows_percent',
        'category' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_bad_win_hits_percent',
        'category' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_bad_win_price_w_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'mobile_rtb_bad_win_price_wo_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'percent',
        'title'       => re(qr(\w)),
        'id'          => 'percent_mobile_rtb_bad_win_price_mobile_rtb_all_w_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'percent',
        'title'       => re(qr(\w)),
        'id'          => 'percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds',
        'category'    => re(qr(\w)),
        'short_title' => re(qr(\w)),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_direct_clicks',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_direct_shows',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'mobile_rtb_block_direct_ctr',
        'category' => re(qr(\w)),
    },
];

our $fields_internal_advnet_context_on_site_stripe = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_ctr',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    }
];

our $fields_internal_advnet_search_on_site_page = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpmh_direct_search_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        conflicts     => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpmh_direct_search_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'conflicts'   => {dimension_fields => ['public_id', 'adfox_block']},
        'section'     => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_hits',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        conflicts     => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'conflicts'   => {dimension_fields => ['public_id', 'adfox_block']},
        'section'     => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_page_ad_shows',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'premium_ads',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_page_ad_shows',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_ads',
        'category' => ignore(),
        conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
];

our $fields_internal_advnet_search_on_site_direct = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_ctr',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpm_direct_search_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpm_direct_search_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpc_direct_search_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_cpc_direct_search_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_search_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
];

our $fields_internal_advnet_search_on_site_premium = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'premium_ctr',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpc_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpc_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    }
];

our $fields_advnet_search_on_site_page = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_hits',
        'category' => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_hits',
        'category' => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'premium_cpmh_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'premium_page_ad_shows',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'premium_ads',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_search_page_ad_shows',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_ads',
        'category' => ignore(),
    },
];

our $fields_advnet_context_on_site_stripe = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'stripe_ctr',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpm_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpmh_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_cpc_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'stripe_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    }
];

our $fields_advnet_context_on_site_direct = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_clicks',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_ctr',
        'category' => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpm_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_cpc_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_context_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
];

our $fields_advnet_context_on_site_rtb = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_shows',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_hits',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpm_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_cpmh_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_block_rpm_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'rtb_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
        'section'     => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_winrate',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_visibility',
        'category' => ignore(),
        'section'  => 'default',
    },
    {
        'id'       => 'rtb_block_all_hits',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'category' => ignore(),
    },
    {
        'id'       => 'rtb_block_cover_ratio',
        'title'    => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'type'     => 'percent',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_clicks',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_shows',
        'category' => re(qr(\w)),
        'section'  => 'default',
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'rtb_block_direct_ctr',
        'category' => re(qr(\w)),
    },
];

our $fields_advnet_context_on_site_page = [
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_fraud_shows',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_fraud_clicks',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_direct_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_market_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_mcb_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_cover_senthits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_senthits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'an_rtb_cover_direct_hits',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_page_ad_shows',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'float',
        'title'    => re(qr(\w)),
        'id'       => 'direct_ads',
        'category' => ignore(),
    },
    {
        'hint'     => re(qr(\w)),
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'direct_context_hits',
        'category' => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_partner_w_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
    {
        'hint'        => re(qr(\w)),
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'direct_ad_cpmh_partner_wo_nds',
        'short_title' => re(qr(\w)),
        'category'    => ignore(),
    },
];

our $fields_video_an_site_instream_publisher = [
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_shows'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_shows_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits_unsold'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_all_hits'
    },
    {
        'shared'      => 1,
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_price_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'shared'      => 1,
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_price_wo_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_partner_price_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_partner_price_wo_nds',
        'short_title' => re(qr(\w)),
    }
];

our $fields_video_an_site_inpage_publisher = [
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_shows'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_shows_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits_own_adv'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_hits_unsold'
    },
    {
        'hint'     => re(qr(\w)),
        'category' => 1,
        'type'     => 'number',
        'title'    => re(qr(\w)),
        'id'       => 'video_bk_all_hits'
    },
    {
        'shared'      => 1,
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_price_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'shared'      => 1,
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_price_wo_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_partner_price_w_nds',
        'short_title' => re(qr(\w)),
    },
    {
        'hint'        => re(qr(\w)),
        'category'    => 3,
        'type'        => 'money',
        'title'       => re(qr(\w)),
        'id'          => 'bk_partner_price_wo_nds',
        'short_title' => re(qr(\w)),
    }
];

our $fields_internal_advnet_context_on_site_content = [

    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_hits',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_win_hits',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_shows',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_shows',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_direct_shows',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_direct_clicks',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_hits_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_win_hits_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_shows_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_shows_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_hits_unsold',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_win_hits_unsold',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_all_hits',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_win_hits_percent',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_bad_shows_percent',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_winrate',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_visibility',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_cover_ratio',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'content_block_direct_ctr',
        'title'    => re(qr(\w)),
        'type'     => 'float'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'percent_content_bad_win_price_content_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'percent'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'percent_content_bad_win_price_content_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'percent'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_rpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_rpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_cpm_all_wo_nds',
        'section'     => 'default',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_block_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_all_wo_nds',
        'section'     => 'default',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_bad_win_price_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'content_bad_win_price_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    }

];

our $fields_internal_advnet_context_on_site_natural = [

    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_hits',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_win_hits',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_shows',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_shows',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_direct_shows',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_direct_clicks',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_hits_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_win_hits_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_shows_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_shows_own_adv',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_hits_unsold',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_win_hits_unsold',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_all_hits',
        'title'    => re(qr(\w)),
        'type'     => 'number'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_win_hits_percent',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_bad_shows_percent',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_winrate',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_visibility',
        'section'  => 'default',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_cover_ratio',
        'title'    => re(qr(\w)),
        'type'     => 'percent'
    },
    {
        'category' => re(qr(\w)),
        'hint'     => re(qr(\w)),
        'id'       => 'natural_block_direct_ctr',
        'title'    => re(qr(\w)),
        'type'     => 'float'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'percent_natural_bad_win_price_natural_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'percent'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'percent_natural_bad_win_price_natural_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'percent'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_rpm_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_rpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_cpmh_all_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_cpmh_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_cpm_all_wo_nds',
        'section'     => 'default',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_block_cpm_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_all_wo_nds',
        'section'     => 'default',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_all_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_bad_win_price_wo_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    },
    {
        'category'    => re(qr(\w)),
        'hint'        => re(qr(\w)),
        'id'          => 'natural_bad_win_price_w_nds',
        'short_title' => re(qr(\w)),
        'title'       => re(qr(\w)),
        'type'        => 'money'
    }

];

our $common_filter_fields = {'login' => {'label' => re(qr(\w)), 'type' => 'text'},};

TRUE;
