package Test::Partner2::Statistics::Subs;
use strict;
use warnings;

use Test::Partner::Utils qw(mock_curdate restore_table);
use Test::Deep;
use qbit;

use Exporter qw(import);
our @EXPORT = qw(
  _mock_app_with_hands_and_dbh
  _do
  _to_fh
  _cmp_bag
  restore_tables
  build_statistics_levels
  unify_fields
  sort_fields
  );

my $table_dumps_dir;
my $data_dir;
my $hands_dir;

sub unify_fields {
    my (@fields) = @_;

    my %ids;
    @fields = grep {$ids{$_->{'id'}}++ == 0} @fields;
    return @fields;
}

sub sort_fields {
    my ($fields) = @_;

    return [sort {$a->{'id'} cmp $b->{'id'}} @$fields];
}

sub _do {
    my ($file_name) = @_;
    return from_json readfile $file_name;
}

my $stat_add_recs = [];

sub _cmp_bag {
    my ($call, $expected, $name) = @_;

    @$stat_add_recs = ();

    $call->();

    cmp_bag($stat_add_recs, $expected, $name,);
}

sub restore_tables {
    my ($dbh, $table_dumps_dir, @tables) = @_;
    restore_table($dbh, $table_dumps_dir, $_) for (@tables);
}

sub build_statistics_levels {
    my ($tree) = @_;

    my $levels = {};
    _build_statistics_levels($tree, $levels);

    return $levels;
}

sub _build_statistics_levels {
    my ($subtree, $levels) = @_;

    foreach my $level (@$subtree) {
        $levels->{$level->{'id'}} = {hash_transform($level, [grep {$_ ne 'children'} keys(%$level)])};
        _build_statistics_levels($level->{'children'}, $levels) if exists($level->{'children'});
    }
}

sub _mock_app_with_hands_and_dbh {
    my ($app) = @_;

    {
        $app->statistics_advnet_context_on_site_rtb;

        no warnings 'redefine';
        my $sub = *{$Application::Model::Statistics::Update::{add_recs}}{CODE};
        *Application::Model::Statistics::RTB::add_recs = sub {
            push @$stat_add_recs, @{$_[1]};
            $sub->(@_);
        };
    }

    my $dbh;
    if (defined($app)) {
        $dbh = $app->partner_db->get_dbh();
    } else {
        $app = Application->new();
        $app->pre_run();

        $dbh = Test::Partner::DB::Mock->connect();

        $dbh->mock($app);
    }

    $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
    $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
    $hands_dir       = "$data_dir/hands";

    $app->set_option(cur_user => {id => 155209804});    # yndx-bessarabov

    $app->api_http_bk;
    $app->{'api_http_bk'} = Test::MockObject::Extends->new($app->{api_http_bk});

    $app->api_bk;
    $app->{'api_bk'} = Test::MockObject::Extends->new($app->{api_bk});

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    mock_curdate('2014-03-01 00:00:00');

    $app->api_http_bk->mock('get_big_search_page_ids',      sub {return []});
    $app->api_http_bk->mock('get_serp_tag_hits',            sub {return []});
    $app->api_balance->mock('get_pages_stat',               sub {return []});
    $app->api_balance->mock('get_dsp_money_completition',   sub {return []});
    $app->api_balance->mock('get_internal_pages_tags_stat', sub {return []});
    $app->api_balance->mock('get_internal_pages_stat',      sub {return []});
    $app->api_balance->mock(
        'get_dsp_stat',
        sub {
            my @headers = qw(
              AGGREGATOR
              AGGREGATORWITHOUTNDS
              BLOCK_ID
              DSP
              DSPWITHOUTNDS
              DSP_ID
              DT
              HITS
              PAGE_ID
              PARTNER
              PARTNERWITHOUTNDS
              PARTNER_STAT_ID
              SHOWS
              );
            my $text = join(
                "\n",
                map {
                    join("\t", (map {$_ // ''} @{$_}{@headers}))
                  } @{_do("$hands_dir/get_dsp_stat.json")}
            );
            $text = join("\t", @headers) . "\n" . $text;
            open(my $fh, '<', \$text);
            return $fh;
        }
    );
    $app->api_http_bk->mock(
        'get_dsp_page_stat',
        sub {
            my ($self, %opts) = @_;
            return _do("$hands_dir/get_dsp_page_stat.json") unless $opts{':return_fh'};
            my @headers = qw(
              Date
              PageID
              ImpID
              DSPID
              WinHits
              WinPrice
              WinPartnerPrice
              Shows
              AllHits
              WinMaxPositionsCount
              AllRealPrice
              BadWinHits
              BadWinPrice
              BadWinPartnerPrice
              BadShows
              BadAllHits
              BadWinMaxPositionsCount
              BadAllRealPrice
              );
            my $text = join(
                "\n",
                map {
                    join("\t", (map {$_ // ''} @{$_}{@headers}))
                  } @{_do("$hands_dir/get_dsp_page_stat.json")}
            );
            open(my $fh, '<', \$text);
            return $fh;
        }
    );
    $app->api_http_bk->mock(
        'get_direct_rtb_stat',
        sub {
            my @headers = qw(
              EventDate
              PageID
              ImpID
              PartnerStatID
              SumBannerShows
              SumBannerClicks
              SumBadBannerShows
              SumBadBannerClicks
              );
            my $text = join("\n", map {join("\t", @{$_}{@headers})} (@{_do("$hands_dir/get_direct_rtb_stat.json")}));
            $text = join("\t", @headers) . "\n" . $text . "\n#END";
            open(my $fh, '<', \$text);
            return $fh;
        }
    );

    $app->api_http_bk->set_always('get_big_search_page_ids', _do("$hands_dir/get_big_search_page_ids.json"));
    $app->api_http_bk->set_always('get_serp_tag_hits',       _do("$hands_dir/get_serp_tag_hits.json"));
    $app->api_balance->set_always('get_pages_stat',          _do("$hands_dir/get_pages_stat.json"));
    $app->api_balance->set_always('get_dsp_money_completition_with_page_id',
        _do("$hands_dir/get_dsp_money_completition_with_page_id.json"));
    $app->api_balance->set_always('get_internal_pages_tags_stat', _do("$hands_dir/get_internal_pages_tags_stat.json"));
    $app->api_balance->set_always('get_internal_pages_stat',      _do("$hands_dir/get_internal_pages_stat.json"));
    $app->api_http_bk->set_always('get_apfraudstat',              _do("$hands_dir/get_apfraudstat.json"));
    $app->api_http_bk->set_always('get_page_block_shows',         _do("$hands_dir/get_page_block_shows.json"));
    $app->api_http_bk->set_always('all_pages_hits_stat_day',      _do("$hands_dir/all_pages_hits_stat_day.json"));

    return ($app, $dbh, $stat_add_recs);
}

TRUE;
