package Test::Partner2::Support::Common;

use qbit;

use Test::Partner2::Mock;
use Test::Partner2::Simple;
use Test::Exception;
use Test::Partner2::Support::MockedForm;

sub new {
    my ($class, %params) = @_;

    die "need 'type'" unless in_array($params{type}, ['cron', 'support']);
    die "need 'result'" unless ref $params{result} eq 'CODE';
    die "need 'save'" if $params{type} eq 'cron' && !ref $params{save} eq 'CODE';
    die "need 'method'" if $params{type} eq 'support' && !$params{method};

    $params{data} = [];

    return bless \%params, $class;
}

sub push_data {
    my ($self, @data) = @_;

    push @{$self->{data}}, @data;
}

sub save_form {
    my ($self, $form) = @_;

    return $self->{save}($form);
}

sub clear_data {
    my ($self, %opts) = @_;

    if ($opts{clear} && $self->{clear}) {
        $self->{clear}($self->{app}, %opts);
    }
}

sub get_result {
    my ($self, %opts) = @_;

    return $self->{result}($self->{app}, %opts);
}

sub call_extra {
    my ($self, %opts) = @_;

    if ($opts{extra}) {
        return $opts{extra}($self->{app}, %opts);
    }
}

sub prepare {
    my ($self) = @_;

    mock_subs(
        {
            'QBit::Application::Model::API::Yandex::StarTrek::get_issue' => sub {
                my ($model, $ticket) = @_;
                return {
                    assignee  => {id => 'cron'},
                    createdBy => {id => 'cron'},
                };
            },
            'QBit::Application::Model::API::Yandex::StarTrek::add_comment' => sub {
                my ($model, $ticket, $comment, $summonees, $attachment) = @_;
                $self->push_data(
                    'add_comment',
                    {
                        ticket     => $ticket,
                        comment    => $comment,
                        summonees  => $summonees,
                        attachment => clone($attachment),
                    }
                );
            },
            'Application::Model::MailNotification::add' => sub {
                my ($model, %opts) = @_;
                $self->push_data('MailNotification::add', {opts => \%opts});
            },
        }
    );
    if ($self->{attachments}) {
        mock_subs(
            {
                'QBit::Application::Model::API::Yandex::StarTrek::get_attachment' => sub {
                    my ($model, $url) = @_;
                    return $self->{attachments}{$url}
                      && +{
                        params => $self->{attachments}{$url},
                        method => $self->{method},
                      };
                },
            }
        );
    }

    mock_curdate('2018-02-10 15:00:00');
    $self->{app}->do('dictionaries', 'update_all_blocks');
}

sub make_all_tests {
    my ($self, $tests) = @_;

    for my $test (@$tests) {
        next if $test->{skip};
        $self->push_data("START - $test->{title}");
        if ($test->{error}) {
            throws_ok {$self->make_test(%$test)} $test->{error}, $test->{title};
        } else {
            $self->make_test(%$test);
        }
        $self->push_data("DONE - $test->{title}");
    }
}

sub make_test_cron {
    my ($self, %opts) = @_;

    $self->clear_data(%opts);

    my $form = Test::Partner2::Support::MockedForm->new($opts{form});

    change_cur_user($self->{app}, 'mocked-yan-manager');
    $self->save_form($form);

    change_cur_user($self->{app}, 'cron');
    $self->{app}->do('system', 'start_task_1');

    $self->push_data($self->get_result(%opts));
    $self->push_data($self->call_extra(%opts));
}

sub make_test_support {
    my ($self, %opts) = @_;

    $self->clear_data(%opts);

    change_cur_user($self->{app}, 'cron');
    my $param =
      $opts{form}
      ? {
        params => $opts{form},
        method => $self->{method},
      }
      : {
        url    => $opts{url},
        params => {ticket => $opts{ticket}},
      };
    my $result = $self->{app}->support->process_from_json($param);

    $self->push_data($self->get_result(%opts));
    $self->push_data($self->call_extra(%opts));
    $self->push_data(
        {
            oneshot_blocks => $result->{changed_block},
            oneshot_pages  => $result->{changed_pages},
        }
    );
}

sub make_test {
    my ($self, %opts) = @_;
    if ($self->{type} eq 'cron') {
        return $self->make_test_cron(%opts);
    } elsif ($self->{type} eq 'support') {
        return $self->make_test_support(%opts);
    }
}

1;
