package Test::Partner2::Utils;

use Exporter qw(import);

@EXPORT_OK = qw(
  $SKIP_MODELS
  check_fields
  clean_for_json
  set_locale_in_tests
  use_common_blocks_table
  );

use Test::Deep;

use qbit;

our $SKIP_MODELS = {
    map {$_ => 1}
      qw (
      context_on_site_adblock
      context_on_site_adblock_action_log
      context_on_site_market
      context_on_site_market_action_log
      context_on_site_market_api
      context_on_site_market_api_action_log
      context_on_site_mcb
      context_on_site_mcb_action_log
      context_on_site_stripe
      context_on_site_stripe_action_log
      indoor
      indoor_action_log
      indoor_block
      indoor_block_action_log
      outdoor
      outdoor_action_log
      outdoor_block
      outdoor_block_action_log
      search_on_site_market
      search_on_site_market_action_log
      search_on_site_market_api
      search_on_site_market_api_action_log
      search_on_site_mcb
      search_on_site_mcb_action_log

      statistics
      statistics_additional_income
      statistics_advnet_context_on_site
      statistics_advnet_context_on_site_adblock
      statistics_advnet_context_on_site_content
      statistics_advnet_context_on_site_direct
      statistics_advnet_context_on_site_market
      statistics_advnet_context_on_site_market_api
      statistics_advnet_context_on_site_mcb
      statistics_advnet_context_on_site_natural
      statistics_advnet_context_on_site_rtb
      statistics_advnet_context_on_site_stripe
      statistics_advnet_on_site
      statistics_advnet_search_on_site
      statistics_advnet_search_on_site_direct
      statistics_advnet_search_on_site_market
      statistics_advnet_search_on_site_market_api
      statistics_advnet_search_on_site_mcb
      statistics_advnet_search_on_site_premium
      statistics_charging
      statistics_dsp
      statistics_dsp_response
      statistics_indoor
      statistics_indoor_block
      statistics_indoor_block
      statistics_internal_advnet_context_on_site
      statistics_internal_advnet_context_on_site_content
      statistics_internal_advnet_context_on_site_direct
      statistics_internal_advnet_context_on_site_natural
      statistics_internal_advnet_context_on_site_rtb
      statistics_internal_advnet_context_on_site_stripe
      statistics_internal_advnet_on_site
      statistics_internal_advnet_search_on_site
      statistics_internal_advnet_search_on_site_direct
      statistics_internal_advnet_search_on_site_premium
      statistics_internal_mobile_app
      statistics_internal_mobile_app_rtb
      statistics_mobile_app
      statistics_mobile_app_rtb
      statistics_mobile_mediation_block
      statistics_outdoor
      statistics_outdoor_block
      statistics_payment
      statistics_reports
      statistics_reports_action_log
      statistics_ssp
      statistics_ssp_context_rtb
      statistics_ssp_context_rtb_rtb
      statistics_ssp_mobile_app
      statistics_ssp_mobile_app_rtb
      statistics_ssp_video_app
      statistics_ssp_video_app_rtb
      statistics_video_an_site
      statistics_video_an_site_fullscreen
      statistics_video_an_site_inpage
      statistics_video_an_site_instream
      statistics_yandex
      )
};

sub check_fields {
    my ($path, $data, $test, $name) = @_;

    my @fields;
    if (ref($path)) {
        @fields = @$path;
    } else {
        @fields = split('/', $path);
    }

    my $field = pop(@fields);

    my @params = ($data, ($field eq '[]' ? array_each($test) : superhashof({$field => $test})), $name);

    if (@fields) {
        check_fields(\@fields, @params);
    } else {
        cmp_deeply(@params);
    }
}

sub clean_for_json {
    my ($object, $for_key) = @_;
    unless (my $ref = ref $object) {
        return $object;
    } elsif ($ref eq 'CODE') {
        return _clean_sub($object, $for_key);
    } elsif ($ref eq 'ARRAY') {
        return [map clean_for_json($_), @$object];
    } elsif ($ref eq 'HASH') {
        my %tmp;
        while (my ($key, $value) = each %$object) {
            $tmp{$key} = clean_for_json($value, $key);
        }
        return \%tmp;
    } elsif ($ref eq 'JSON::XS::Boolean') {
        return $object;
    } else {
        return "ref<$ref>";
    }
}

sub _clean_sub {
    my ($sub, $key) = @_;

    $key //= '';
    if ($key eq 'check' or $key eq 'get' or $key eq 'fix_type') {
        return "sub{...}";
    }

    local $Data::Dumper::Deparse = 1;
    my $code = Dumper($sub);

    if ($code =~ /package (?:QBit::GetText)|(?:QBit::Application::Model::Multistate);/) {
        return $sub->();
    }

    return "sub{...}";
}

sub set_locale_in_tests {
    my ($app, $locale) = @_;

    die "Unknown locale" unless in_array($locale, [qw(en ru C)]);
    # TODO: if ('C') {override gettext() (just append prefix or capitalize to simlpe check for getext); }

    my $locales = $app->get_option('locales', {});
    my $lang;
    if (exists($locales->{$locale})) {
        $lang = $locales->{$locale}{code};
    }
    $lang ||= 'C';

    QBit::GetText::set_locale(
        project => $app->get_option('locale_domain', 'application'),
        path    => $app->get_option('ApplicationPath') . 'locale',
        lang    => $lang,
    );
}

TRUE;
