package TestGraphApplication::Model;

use qbit;
use base qw(QBit::Application::Model QBit::Application::Model::Multistate);

__PACKAGE__->multistates_graph(
    empty_name  => 'New',
    multistates => [
        #[working          => 'Working'],
        #[testing          => 'Testing'],
        #[stopped          => 'Stopped'],
        #[deleted          => 'Deleted'],
        #[check_statistics => 'Check statistics'],
        [archived => 'Archived'],
    ],
    actions => {
        edit         => 'Edit',
        to_archive   => 'Move to archive',
        from_archive => 'Remove from archive',
    },
    multistate_actions => [
        {
            action => 'edit',
            from   => 'not archived',
        },
        {
            action    => 'to_archive',
            from      => 'not archived',
            set_flags => ['archived']
        },
        {
            action      => 'from_archive',
            from        => 'archived',
            reset_flags => ['archived']
        },
    ]
);

1;
