use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use feature qw(say);

use qbit;

my @LEVELS;
my $ROLE_ID;
my $ROLE_NAME;

my %CATEGORY_ID = (
    1 => 'COUNTER',
    2 => 'CALCULATED',
    3 => 'CASH',
    4 => 'PAGE_FIELDS',
    5 => 'CALCULATED_WITH_MONEY',
);

sub check_level {
    my ($hash, $level) = @_;

    push @LEVELS, $hash->{'title'};

    my %category;

    foreach my $f (@{$hash->{fields}}) {
        push @{$category{$f->{category}}}, $f;
    }

    foreach my $category_id (keys %category) {
        my $has_default_section = grep {($_->{section} // '') eq 'default'} @{$category{$category_id}};

        my $message =
          "Role ID $ROLE_ID ($ROLE_NAME) has default section for category $category_id $CATEGORY_ID{$category_id} at "
          . join(' -> ', @LEVELS);

        if ($has_default_section) {
            pass($message);
        } else {
            fail($message);
        }
    }

    if ($hash->{children}) {
        foreach my $element (@{$hash->{children}}) {
            check_level($element, $level + 1);
        }
    }

    pop @LEVELS;

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        my $user = {
            login   => 'mocked-yan-partner',
            user_id => 1009,
        };

        my $roles = $app->rbac->get_roles();

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        foreach my $role (@{$roles}) {
            $ROLE_ID   = $role->{id};
            $ROLE_NAME = $role->{name};

            # Указываем в базе роль для пользователя
            # и переключаемся на него
            $app->partner_db->_do('delete from user_role');
            $app->partner_db->_do("insert into user_role values ($user->{user_id}, $ROLE_ID)");
            change_cur_user($app, $user->{login});

            my $tree = $app->statistics->get_tree();

            if (scalar @$tree == 0) {
                pass("Role ID $ROLE_ID ($ROLE_NAME) get nothing in get_tree()");
            } else {
                foreach my $element (@$tree) {
                    check_level($element, 0);
                }
            }

        }

    },
    do_not_die_on_fail   => 1,
    create_clickhouse_db => TRUE,
);
