#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner::Utils qw( request_to_api get_clickhouse_statistics_test_data );

use qbit;

my $PATH_NAME   = 'statistics';
my $METHOD_NAME = 'get';

run_tests(
    sub {
        my ($app) = @_;

        fill_clickhouse_database($app);

        my ($stdout, $stderr, $exit_status) = request_to_api(
            app          => $app,
            path         => $PATH_NAME,
            method       => $METHOD_NAME,
            ext          => 'json',
            query_string => 'lang=C&oauth_token=mocked-yan-partner&pretty=1'
              . '&period=2019-04-04&period=2019-04-05'
              . '&level=advnet_context_on_site_rtb&field=rtb_partner_wo_nds&field=rtb_block_shows'
              . '&entity_field=campaign_id&dimension_field=dsp_id_name'
              . '&filter=["campaign_id","=",41443]',
        );

        is($exit_status, 1, 'exit status');

        eq_or_diff($stderr, '', 'stderr', {context => 1});

        eq_or_diff(
            $stdout, 'Status: 200 OK
X-Yandex-Login: mocked-yan-partner
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{
   "data" : {
      "currencies" : [
         {
            "code" : "EUR",
            "id" : "3"
         },
         {
            "code" : "RUB",
            "id" : "2"
         },
         {
            "code" : "USD",
            "id" : "1"
         }
      ],
      "data" : [
         {
            "campaign_id" : 41443,
            "currency_id" : 2,
            "dsp_id_name" : 1,
            "rtb_block_shows" : 63,
            "rtb_partner_wo_nds" : 823.54
         }
      ],
      "measures" : {
         "rtb_block_shows" : {
            "index" : 2,
            "title" : "RTB-blocks shows",
            "type" : "number",
            "unit" : "count"
         },
         "rtb_partner_wo_nds" : {
            "index" : 1,
            "title" : "Partnerships for RTB-blocks (w/o&nbsp;VAT)",
            "type" : "money",
            "unit" : "money"
         }
      },
      "report_title" : "Report for period 04.04.2019 - 05.04.2019",
      "total" : {
         "2" : {
            "rtb_block_shows" : 63,
            "rtb_partner_wo_nds" : 823.54
         }
      }
   },
   "result" : "ok"
}
', 'stdout', {context => 1}
        );
    },
    application_package  => 'API',
    create_clickhouse_db => TRUE,
);

sub fill_clickhouse_database {
    my ($app) = @_;

    my $data = get_clickhouse_statistics_test_data(
        $app,
        pk_data => [
            {
                dt             => '2019-04-04',
                page_id        => 41443,
                block_id       => 3,
                dsp_id         => 1,
                currency_id    => 2,
                shows          => 13,
                partner_wo_nds => 5893059289401
            },
            {
                dt             => '2019-04-05',
                page_id        => 41443,
                block_id       => 3,
                dsp_id         => 1,
                currency_id    => 2,
                shows          => 50,
                partner_wo_nds => 2342346234283
            }
        ],
        accessors => [qw(statistics_advnet_context_on_site_rtb)]
    );

    $app->clickhouse_db->statistics->add_multi($data);
}
