#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_bk mock_agreement_checker mock_format_system);

use Test::More;
use Test::Deep;

use qbit;

my $DATA = [
    # РЕКЛАМА НА САЙТАХ
    {
        testname => 'РЕКЛАМА НА САЙТАХ. RTB-Блок',
        model    => 'context_on_site_rtb',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 41443, id => 1},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Direct-Блок',
        model    => 'context_on_site_direct',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 142898, id => 1},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Stripe-Блок',
        model    => 'context_on_site_stripe',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 41443, id => 40},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Спецразмещение',
        model    => 'search_on_site_premium',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 111161, id => 2},
    },
    {
        testname => 'РЕКЛАМА НА САЙТАХ. Поисковый Блок',
        model    => 'search_on_site_direct',
        login    => 'mocked-yan-partner',
        id       => {campaign_id => 111161, id => 1},
    },
    ## СЕРВИСЫ ЯНДЕКСА
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Direct-Блок',
        model    => 'internal_context_on_site_direct',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 88848, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. RTB-Блок',
        model    => 'internal_context_on_site_rtb',
        login    => 'mocked-internal-administrator',
        id       => {campaign_id => 88848, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Stripe-Блок',
        model    => 'internal_context_on_site_stripe',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 2, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Спецразмещение',
        model    => 'internal_search_on_site_premium',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 128843, id => 1},
    },
    {
        testname => 'СЕРВИСЫ ЯНДЕКСА. Поисковый блок',
        model    => 'internal_search_on_site_direct',
        login    => 'mocked-internal-manager',
        id       => {campaign_id => 118826, id => 1},
    },
    # РЕКЛАМА В ПРИЛОЖЕНИЯХ
    {
        testname => 'РЕКЛАМА В ПРИЛОЖЕНИЯХ. RTB-Блок',
        model    => 'mobile_app_rtb',
        login    => 'mocked-mobile-app-partner',
        id       => {context_page_id => 43569, id => 1},
    },
    # РЕКЛАМА В ВИДЕО
    {
        testname => 'РЕКЛАМА В ВИДЕО. InStream-Блок',
        model    => 'video_an_site_instream',
        login    => 'mocked-video-partner',
        id       => {page_id => 154689, id => 3},
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_format_system($app);

        foreach my $testdata (@$DATA) {
            my ($login, $model, $id, $testname) = @$testdata{qw( login  model  id  testname )};

            next
              unless $app->$model->get_registered_actions()->{'duplicate'}
                  || $app->$model->get_registered_actions_rights()->{'duplicate'};

            change_cur_user($app, $login);

            subtest(
                $testname => sub {

                    _duplicate_and_compare($app, $model, $id);

                }
            );
        }

    },
    do_not_die_on_fail => 1
);

sub _duplicate_and_compare {
    my ($app, $model, $id) = @_;

    # Чтобы не было проблем с графом статусов
    if ($model eq 'internal_context_on_site_rtb') {
        $model = 'context_on_site_rtb';
    }
    $app->partner_db->$model->edit($id, {multistate => 0});

    my $public_id     = $app->$model->public_id($id);
    my $new_public_id = $app->$model->duplicate(public_id => $public_id);
    my $new_id        = $app->$model->_split_id($new_public_id);

    my $fields = $app->$model->get_model_fields;
    delete $fields->{id};
    my $field_names = [keys %$fields];

    my $block     = $app->$model->get($id,     fields => $field_names);
    my $new_block = $app->$model->get($new_id, fields => $field_names);

    is_deeply($block, $new_block,
        sprintf('original block (id = %s) is identical to duplicate (id = %s)', $public_id, $new_public_id,));
}
