#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Differences;
use Test::More tests => 2 + 4;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_bk_data get_new_indoor);
use Test::Partner2::Mock qw(
  mock_agreement_checker
  mock_balance
  mock_bk
  mock_maps
  mock_utils_partner2
  );

use qbit;

use PiConstants qw($BOOKMAKER_FLAG_ID);
$BOOKMAKER_FLAG_ID .= '';

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $id_with_testmode = $app->indoor->add(get_new_indoor());

        eq_or_diff(
            $app->indoor->get($id_with_testmode, fields => [qw(page_id filters multistate multistate_name)]),
            {
                'filters'         => [$BOOKMAKER_FLAG_ID],
                'multistate'      => '8328',
                'multistate_name' => "Need update.\nCheck statistics.\nTesting.",
                'page_id'         => '1000',
            },
            'check create'
        );

        $app->indoor->cron_init_campaigns();

        eq_or_diff(
            $app->indoor->get($id_with_testmode, fields => [qw(page_id filters multistate multistate_name)]),
            {
                'filters'         => [$BOOKMAKER_FLAG_ID],
                'multistate'      => '8576',
                'multistate_name' => "Check statistics.\nAdded to Balance.\nTesting.",
                'page_id'         => '1000',
            },
            'check after init'
        );

        my $id_without_testmode = $app->indoor->add(get_new_indoor(is_in_testmode => 0));

        eq_or_diff(
            $app->indoor->get($id_without_testmode, fields => [qw(page_id filters multistate multistate_name)]),
            {
                'filters'         => [$BOOKMAKER_FLAG_ID],
                'multistate'      => '640',
                'multistate_name' => "Check statistics.\nOn moderation.",
                'page_id'         => '1001',
            },
            'check create'
        );

        $app->indoor->cron_init_campaigns();

        eq_or_diff(
            $app->indoor->get($id_without_testmode, fields => [qw(page_id filters multistate multistate_name)]),
            {
                'filters'         => [$BOOKMAKER_FLAG_ID],
                'multistate'      => '896',
                'multistate_name' => "Check statistics.\nAdded to Balance.\nOn moderation.",
                'page_id'         => '1001',
            },
            'check after init'
        );
    },
);

sub mock_app {
    my ($app) = @_;

    mock_bk($app);
    mock_maps($app);
    mock_balance($app);
    mock_agreement_checker($app);
    mock_utils_partner2($app);
}
