use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my ($page_id, $id) = ('153745', '1');
        my $prefix = $app->context_on_site_adblock->public_id_prefix();

        my $public_id = $prefix . "$page_id-$id";

        my $fields  = [qw(public_id)];
        my $filter1 = ['AND', [['id', '=', $id]]];
        my $filter2 = ['AND', [['id', '=', "$page_id-$id"]]];
        my $filter3 = ['AND', [['id', '=', $public_id]]];

        my $data1 = $app->context_on_site_adblock->get_all(fields => $fields, filter => $filter1);
        my $data2 = $app->context_on_site_adblock->get_all(fields => $fields, filter => $filter2);
        my $data3 = $app->context_on_site_adblock->get_all(fields => $fields, filter => $filter3);

        my @found_by_id = grep {$_->{'public_id'} eq $public_id} @$data1;

        ok(@found_by_id, 'Found by id');
        ok(@$data2 && $data2->[0]{'public_id'} eq $public_id, 'Found by page_id and id');
        ok(@$data3 && $data3->[0]{'public_id'} eq $public_id, 'Found by public_id');
    },
);
