use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply);

sub check_adblock_blocks_before {
    my ($app) = @_;

    my ($is_ok_before, $details_before) =
      $app->qbit_validator_checker->check_all_elements_in_model(accessor => 'context_on_site_adblock');
    ok($is_ok_before, 'before turn_on_dsp() there is no problems in context_on_site_adblock');

    my $blocks_before = $app->context_on_site_adblock->get_all(
        fields => [qw(public_id dsps)],
        filter => ['AND', [['id', 'IN', ['R-AB-153745-1',]],]],
    );

    cmp_deeply(
        $blocks_before,
        [
            {
                dsps      => [1,],
                public_id => 'R-AB-153745-1',
            },
        ],
        'got expected adblock blocks data before turn_on_dsp()',
    );
}

sub check_adblock_blocks_after {
    my ($app) = @_;

    my ($is_ok_after, $details_after) =
      $app->qbit_validator_checker->check_all_elements_in_model(accessor => 'context_on_site_adblock');
    ok($is_ok_after, 'after turn_on_dsp() there is no problems in context_on_site_adblock');

    my $blocks_after = $app->context_on_site_adblock->get_all(
        fields => [qw(public_id dsps)],
        filter => ['AND', [['id', 'IN', ['R-AB-153745-1',]],]],
    );

    cmp_deeply(
        $blocks_after,
        [
            {
                dsps      => [1,],
                public_id => 'R-AB-153745-1',
            },
        ],
        'got expected adblock blocks data after turn_on_dsp()',
    );
}

run_tests(
    sub {
        my ($app) = @_;

        check_adblock_blocks_before($app);

        my $dsp_id = 2317563;
        $app->context_on_site_adblock->turn_on_dsp({id => $dsp_id, multistate => 15, types => [0], 'tag' => 'test'});

        check_adblock_blocks_after($app);
    },
);
