#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-partner');

        my $block_fields = $app->context_on_site_rtb->get({campaign_id => 41443, id => 1}, fields => [qw(public_id)]);

        my $public_id = $block_fields->{'public_id'};

        my $test_data = [
            {
                method   => 'do_action',
                args     => [$public_id, 'set_check_statistics'],
                status   => 'check_statistics',
                expected => TRUE,
            },
            {
                method   => 'do_action',
                args     => [$public_id, 'reset_check_statistics'],
                status   => 'check_statistics',
                expected => FALSE,
            },
        ];

        foreach my $test_case (@$test_data) {
            my $method = $test_case->{method};
            my @args   = @{$test_case->{args}};

            $app->context_on_site_rtb->$method(@args);

            is(
                $app->context_on_site_rtb->check_multistate_flag(
                    $app->context_on_site_rtb->get($public_id, fields => ['multistate'])->{'multistate'},
                    $test_case->{status}
                ),
                $test_case->{expected},
                'Check status ' . $test_case->{status},
              );
        }
    }
);
