#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw( compare_formats );

use Test::More;
use qbit;

my $data = {
    'context_on_site_adblock'         => [],
    'context_on_site_direct'          => [],
    'context_on_site_rtb'             => [],
    'internal_context_on_site_direct' => [],
    'internal_context_on_site_rtb'    => [],
    'internal_mobile_app_rtb'         => [],
    'internal_search_on_site_direct'  => [],
    'internal_search_on_site_premium' => [],
    'mobile_app_rtb'                  => [],
    'search_on_site_direct'           => [],
    'search_on_site_premium'          => [],
    'ssp_context_on_site_rtb'         => [],
    'ssp_mobile_app_rtb'              => [],
    'ssp_video_an_site_rtb'           => []
};

run_tests(
    sub {
        my ($app) = @_;

        my $path_to_data = lib::abs::path('direct_blocks/data.json');
        my $json_data    = from_json(readfile($path_to_data));

        my @models = grep {blessed($app->{$_}) && $app->$_->can('direct_block_types')} keys(%$app);

        my $got_data = {};
        foreach my $accessor (@models) {

            subtest $accessor => sub {
                my $direct_block_types = $app->$accessor->direct_block_types();
                $got_data->{$accessor} = compare_formats($direct_block_types, $json_data->{$accessor});
            };
        }

        # Usage: > ./prove *.t :: --self_update 2>&1 | less
        if (need_self_update()) {
            writefile($path_to_data, to_json($got_data, pretty => TRUE));
        }
    },
    dont_create_database => TRUE,
    do_not_die_on_fail   => TRUE,
);
