use Test::Partner2::Simple;

use Test::TestBuilder;
use Test::Deep qw(cmp_deeply ignore);
use Test::Most;
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh build_statistics_levels sort_fields );
use Test::Partner2::Statistics::Data qw(
  @common_fields
  $fields_dsp
  $dimension_field_dsp
  $entity_filter_field_user
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        _mock_app_with_hands_and_dbh($app);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'dsp';
        my $level    = $levels->{$level_id};

        cmp_deeply($level->{'conflict_fields'}, [], 'conflict_fields');

        cmp_deeply($level->{'dimension_fields'}, [@common_fields, @$dimension_field_dsp], 'dimension_fields');

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {
                    'type'       => 'straight_number',
                    'label'      => re(qr(\w)),
                    'id'         => 'id',
                    'only_group' => 1
                },
                {
                    'verbatim'   => 1,
                    'label'      => re(qr(\w)),
                    'id'         => 'short_caption',
                    'only_group' => 1
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'login',
                    'label'      => re(qr(\w)),
                    'id'         => 'login',
                    'only_group' => 1
                }
            ],
            'entity_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_fields'},
            {
                'owner' => {
                    'subfields' => $entity_filter_field_user,
                    'label'     => re(qr(\w)),
                    'type'      => 'subfilter'
                },
                'owner_id'                => {'label' => re(qr(\w)), 'type' => 'number'},
                'id'                      => {'label' => re(qr(\w)), 'type' => 'number'},
                'short_caption'           => {'label' => re(qr(\w)), 'type' => 'text'},
                'unmoderated_rtb_auction' => {'label' => re(qr(\w)), 'type' => 'boolean'},
                'tag'                     => {
                    'label' => re(qr(\w)),
                    'type'  => 'text',
                },
                'multistate' => {
                    'values' => {
                        'linked_in_balance'          => re(qr(\w)),
                        'working'                    => re(qr(\w)),
                        'deleted'                    => re(qr(\w)),
                        'working_on_all_platforms'   => re(qr(\w)),
                        'working_on_yandex_services' => re(qr(\w)),
                        'not_need_create_in_pi'      => re(qr(\w)),
                        'need_create_in_pi'          => re(qr(\w)),
                        'created_in_bk'              => re(qr(\w)),
                        'created_in_pi'              => re(qr(\w)),
                        'need_approve'               => re(qr(\w)),
                        'edited'                     => re(qr(\w))
                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'types' => {
                    'values' => [
                        {
                            'label' => re(qr(\w)),
                            'id'    => 0,
                            'key'   => 'id0'
                        },
                        {
                            'label' => re(qr(\w)),
                            'id'    => 1,
                            'key'   => 'id1'
                        },
                        {
                            'label' => re(qr(\w)),
                            'id'    => 2,
                            'key'   => 'id2'
                        }
                    ],
                    'label' => re(qr(\w)),
                    'type'  => 'dictionary'
                },
            },
            'entity_filter_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                [
                    {
                        'name'         => 'owner.login',
                        'login_filter' => 'dsp=1',
                        'label'        => re(qr(\w))
                    },
                    {
                        'hint'  => re(qr(\w)),
                        'name'  => 'owner.client_id',
                        'label' => re(qr(\w))
                    },
                    {'name' => 'owner.contract_id', 'label' => re(qr(\w))},
                    {'name' => 'types',             'label' => re(qr(\w))},
                ],
                [
                    {'name' => 'id',            'label' => re(qr(\w))},
                    {'name' => 'short_caption', 'label' => re(qr(\w))},
                    {'name' => 'multistate',    'label' => re(qr(\w))}
                ]
            ],
            'entity_filter_simple_fields'
        );

        cmp_deeply(sort_fields($level->{'fields'}), sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields_dsp]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields_dsp), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');

    },
    locale => "C"
);
