use Test::Partner2::Simple;

use Test::TestBuilder;
use Test::Deep qw(cmp_deeply ignore);
use Test::Most;
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh restore_tables _do );
use Test::Partner2::Statistics::Data qw(
  @common_fields
  $fields_dsp
  $dimension_field_dsp
  $entity_filter_field_user
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $dbh;
        ($app, $dbh) = _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $dbh, $table_dumps_dir, qw(
              all_pages
              internal_site
              users
              internal_context_on_site_campaign
              dsp
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;", {}, %currencies);

        ##### 1
        {
            my $sort_func = sub {
                $a->{'dsp_id'} <=> $b->{'dsp_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'}
                  || $a->{'campaign_id'} <=> $b->{'campaign_id'};
            };

            my $file_path = "$data_dir/_get_stat_from_balance/dsp.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [
                sort $sort_func @{$app->statistics_dsp->_get_stat_from_balance(map {$_ => curdate(oformat => 'db')}
                          qw(from to))}
                      ];

            cmp_deeply($got, $expect, '_get_stat_from_balance is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 2
        {
            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => ["id",],
                fields           => [
                    "dsp_bids",                "dsp_shows",
                    "dsp_cpm_charging_wo_nds", "dsp_cpm_charging_w_nds",
                    "dsp_charging_wo_nds",     "dsp_charging_w_nds",
                ],
                levels => [{id => "dsp",},],
                period => "today",
                total  => 0,
                vat    => 2,
            );

            my $sort_func = sub {
                $a->{'id'} <=> $b->{'id'} || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            $app->statistics_dsp->update_statistics(map {$_ => curdate(oformat => 'db')} qw(from to));

            my $file_path = "$data_dir/get_statistics/dsp.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 3
        {
            my %get_statistics_arguments = (
                dimension_fields => ["page_id", "campaign"],
                entity_fields    => [],
                fields => ["dsp_bids", "dsp_shows", "dsp_charging_w_nds"],
                dimension_filter => ["AND", [["page_id", "=", ["47635", "2"]], ["campaign", "=", ["47635"]]]],
                levels => [{id => "dsp",},],
                period => "today",
                total  => 0,
                vat    => 0,
            );

            my $sort_func = sub {
                $a->{'currency_id'} <=> $b->{'currency_id'}
                  || $a->{'internal_context_campaign_id'} <=> $b->{'internal_context_campaign_id'};
            };

            my $file_path = "$data_dir/get_statistics/dsp_with_dimension_filters.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct with dimension filters');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 4
        {
            my %get_statistics_arguments = (
                dimension_fields => ["is_internal_campaign"],
                entity_fields    => [],
                fields           => ["dsp_bids", "dsp_shows", "dsp_cpm_charging_w_nds", "dsp_charging_w_nds"],
                levels => [{id => "dsp",},],
                period => "today",
                total  => 0,
                vat    => 0,
            );

            my $sort_func = sub {
                $a->{'currency_id'} <=> $b->{'currency_id'}
                  || $a->{'is_internal_campaign'} <=> $b->{'is_internal_campaign'};
            };

            my $file_path = "$data_dir/get_statistics/dsp_with_is_internal_campaign.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct with dimension filter "is_internal_campaign"');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }
    },
    fill_databases     => 0,
    do_not_die_on_fail => need_self_update() ? 1 : 0
);
