use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore re);
use Test::Differences qw( eq_or_diff );

use qbit;

use Test::Partner2::Statistics::Data qw(
  @common_fields
  $dimension_field_dsp
  $entity_field_login
  $entity_filter_field_user
  $fields_dsp
  );
use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh build_statistics_levels sort_fields );

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'charging';
        my $level    = $levels->{$level_id};

        cmp_deeply($level->{'conflict_fields'}, [], 'conflict_fields');

        cmp_deeply($level->{'dimension_fields'}, [@common_fields, @$dimension_field_dsp], 'dimension_fields');

        cmp_deeply($level->{'entity_fields'}, [$entity_field_login,], 'entity_fields');

        cmp_deeply($level->{'entity_filter_fields'}, $entity_filter_field_user, 'entity_filter_fields');

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                {'name' => 'login',     'label' => re(qr(\w))},
                {'name' => 'user_type', 'label' => re(qr(\w))},
                {'name' => 'email',     'label' => re(qr(\w))},
                {'name' => 'phone',     'label' => re(qr(\w))},
                {
                    'hint'  => re(qr(\w)),
                    'name'  => 'client_id',
                    'label' => re(qr(\w))
                },
                {'name' => 'contract_id', 'label' => re(qr(\w))},
                {'name' => 'lastname',    'label' => re(qr(\w))},
                {'name' => 'name',        'label' => re(qr(\w))},
                {'name' => 'id',          label   => re(qr(\w))},
            ],
            'entity_filter_simple_fields'
        );

        my $fields = [
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'charging_w_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
            },
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'charging_wo_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
                'section'     => 'default',
            }
        ];

        cmp_deeply(sort_fields($level->{'fields'}),
            sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields, @$fields_dsp]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields([@$fields, @$fields_dsp]), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');

    },
    locale => "C"
);
