use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::Most;
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data qw(
  @common_fields
  $dimension_field_dsp
  $entity_field_login
  $entity_filter_field_user
  $fields_dsp
  );
use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh _do restore_tables );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $dbh;
        ($app, $dbh) = _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $dbh, $table_dumps_dir, qw(
              users
              dsp
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;", {}, %currencies);

        $app->statistics_dsp->update_statistics(map {$_ => curdate(oformat => 'db')} qw(from to));

        my %get_statistics_arguments = (
            dimension_fields => [],
            entity_fields    => ['login'],
            fields           => ["charging_wo_nds", "charging_w_nds",],
            levels           => [{id => "charging",},],
            period           => "today",
            total            => 0,
            vat              => 2,
        );

        my $update_statistics_data =
          [sort {$a->{'login'} cmp $b->{'login'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
              @{_do("$data_dir/get_statistics/charging.json")}];

        is_deeply(
            [
                sort {$a->{'login'} cmp $b->{'login'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
                  @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}
            ],
            $update_statistics_data,
            'get_statistics is correct'
        );

        my $login = "lamoda-tech";
        $get_statistics_arguments{'levels'}[0]{'filter'} = ["AND", [["login", "IN", [$login,],],],];

        $update_statistics_data = [grep {$_->{'login'} eq $login} @$update_statistics_data];

        is_deeply(
            [
                sort {$a->{'login'} cmp $b->{'login'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
                  @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}
            ],
            $update_statistics_data,
            "get_statistics is correct for login '$login'"
        );
    },
    fill_databases => 0,
);
