#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $instream_types = $app->video_an_site_instream->get_types();

        my %table_fields = map {$_ => TRUE} $app->partner_db->statistics_video_an_site_page->field_names();

        my @not_found_fields = grep {!$table_fields{$_}} map {
            my $type = $_->{'bk'};
            ("instream_block_${type}_shows", "instream_block_${type}_hits", "instream_block_${type}_all_hits",)
        } @$instream_types;

        if (@not_found_fields) {
            fail(
                sprintf('In table "statistics_video_an_site_page" not found fields: %s', join(', ', @not_found_fields))
            );
        } else {
            pass('All fields exists');
        }
    },
    dont_create_database => TRUE,
);
