#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        # login as a video partner
        $app->{'__CURRENT_USER_RIGHTS__'} = {};
        $app->set_cur_user({id => 1010, login => 'mocked-video-partner'});

        my $stat_accessor = "statistics_video_an_site_instream";

        my $input_data = [
            {
                dt          => '2017-03-01',
                page_id     => 154689,
                block_id    => 2,
                dsp_id      => 1,
                currency_id => 2,

                instream_block_shows                  => 5,
                instream_block_shows_own_adv          => 0,
                instream_block_hits                   => 5,
                instream_block_hits_own_adv           => 0,
                instream_block_hits_unsold            => 0,
                instream_block_win_hits               => 6,
                instream_block_win_hits_own_adv       => 0,
                instream_block_win_hits_unsold        => 0,
                instream_all_w_nds                    => 19198010000,
                instream_all_wo_nds                   => 16269500000,
                all_w_nds                             => 19198010000,
                all_wo_nds                            => 16269500000,
                partner_w_nds                         => 9599005000,
                partner_wo_nds                        => 8134750000,
                instream_partner_w_nds                => 9599005000,
                instream_partner_wo_nds               => 8134750000,
                instream_block_bad_shows              => 0,
                instream_block_bad_shows_own_adv      => 0,
                instream_block_bad_win_hits           => 0,
                instream_block_bad_win_hits_own_adv   => 0,
                instream_block_bad_win_hits_unsold    => 0,
                instream_bad_win_price_w_nds          => 0,
                instream_bad_win_price_wo_nds         => 0,
                bad_win_price_w_nds                   => 0,
                bad_win_price_wo_nds                  => 0,
                instream_bad_win_partner_price_w_nds  => 0,
                instream_bad_win_partner_price_wo_nds => 0,
                bad_win_partner_price_w_nds           => 0,
                bad_win_partner_price_wo_nds          => 0,
            }
        ];

        # add some dummy statistics
        $app->clickhouse_db->statistics->add_multi($app->$stat_accessor->convert_mysql_to_clickhouse($input_data));

        # allow view video_an_site_sum_all_*
        my $tmp_rights = $app->add_tmp_rights(qw(statistics_video_an_site_view_stat_field_all statistics_from_ch));

        # Check that it's possible to get summary fields which depend on fields from 3 video products
        # in the situation when the user has statistics for only ONE product.
        #
        my $stat = $app->statistics->get_statistics(
            period => ['2017-03-01', '2017-03-01'],
            fields => [
                'video_an_site_all_hits',
                'video_an_site_all_shows',
                'video_an_site_all_hits_own_adv',
                'video_an_site_all_shows_own_adv',
                'video_an_site_all_hits_unsold',
                'video_an_site_all_shows',
                'video_an_site_sum_all_hits',
                'video_an_site_sum_partner_w_nds',
                'video_an_site_sum_partner_wo_nds',

                'video_an_site_sum_all_w_nds',
                'video_an_site_sum_all_wo_nds',
            ],
            dimension_fields => ['date|day', 'currency_id'],
            dimension_filter => undef,
            entity_fields    => [],
            total            => 0,
            vat              => -1,
            levels => [{filter => undef, id => 'video_an_site'}],
        );

        my $expected_data = [
            {
                'video_an_site_all_hits_unsold'    => 1,
                'currency_id'                      => '2',
                'video_an_site_sum_all_wo_nds'     => '1.63',
                'date'                             => '2017-03-01',
                'video_an_site_all_hits'           => 5,
                'video_an_site_sum_all_w_nds'      => '1.92',
                'video_an_site_all_hits_own_adv'   => 0,
                'video_an_site_sum_partner_w_nds'  => '0.96',
                'video_an_site_all_shows'          => 5,
                'video_an_site_sum_all_hits'       => 6,
                'video_an_site_all_shows_own_adv'  => 0,
                'video_an_site_sum_partner_wo_nds' => '0.81'
            }
        ];

        cmp_deeply($stat->{'data'}, $expected_data, "summary fields can be seen");
    },
    create_clickhouse_db => TRUE,
);
