use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate get_test_data_and_update_if_needed);
use Test::More;
use Test::Deep;

use qbit;

my $DATE    = '2017-10-22';
my $PAGE_ID = 53100;

sub add_data_to_database {
    my ($app) = @_;

    $app->partner_db->users->add(
        {
            id        => 369738908,
            login     => 'kp-team',
            client_id => 467949,
            opts      => to_json(
                {
                    has_tutby_agreement  => 0,
                    has_common_offer     => 0,
                    has_mobile_mediation => 0,
                    has_rsya             => 1,
                    has_approved         => 0
                }
            ),
        }
    );

    $app->partner_db->site->add(
        {
            id         => 2,
            domain     => 'kinopoisk.ru',
            multistate => 4,
        }
    );

    $app->partner_db->context_on_site_campaign->add(
        {
            id         => 3,
            page_id    => $PAGE_ID,
            domain_id  => 2,
            owner_id   => 369738908,
            multistate => 17,
            creator_id => 369738908,
        }
    );

    $app->partner_db->context_on_site_rtb->add(
        {
            campaign_id => $PAGE_ID,
            id          => 1,
            multistate  => 2,
        }
    );

    $app->partner_db->currencies->add(
        {
            id   => 2,
            code => 'RUB',
        }
    );

    return 1;
}

sub update_statistics {
    my ($app) = @_;

    no strict 'refs';
    no warnings 'redefine';

    local *{'QBit::Application::Model::API::Yandex::Balance::get_dsp_stat'} = sub {
        my ($self, %opts) = @_;

        my @headers =
          qw(PAGE_ID BLOCK_ID DSP_ID DT HITS DSP DSPWITHOUTNDS PARTNER PARTNERWITHOUTNDS SHOWS AGGREGATORWITHOUTNDS AGGREGATOR TOTAL_RESPONSE_COUNT TOTAL_BID_SUM CLIENT_ID PARTNER_STAT_ID);

        my $tsv = join("\t", @headers) . "\n";

        if ($opts{from} eq $DATE) {
            if ($opts{include_partner_stat_id}) {
                my $struct = [
                    {
                        AGGREGATOR           => "",
                        AGGREGATORWITHOUTNDS => "",
                        BLOCK_ID             => 1,
                        DSP                  => 27.60492,
                        DSP_ID               => 2317563,
                        DSPWITHOUTNDS        => 23.394,
                        DT                   => "$DATE 00:00:00",
                        HITS                 => 560,
                        PAGE_ID              => $PAGE_ID,
                        PARTNER              => 13.80246,
                        PARTNER_STAT_ID      => 345,
                        PARTNERWITHOUTNDS    => 11.697,
                        SHOWS                => 392,
                        TOTAL_BID_SUM        => 412.384,
                        TOTAL_RESPONSE_COUNT => 2240,
                        CLIENT_ID            => 0,
                    },
                    {
                        AGGREGATOR           => "",
                        AGGREGATORWITHOUTNDS => "",
                        BLOCK_ID             => 1,
                        DSP                  => 10.4961,
                        DSP_ID               => 2563108,
                        DSPWITHOUTNDS        => 8.895,
                        DT                   => "$DATE 00:00:00",
                        HITS                 => 111,
                        PAGE_ID              => $PAGE_ID,
                        PARTNER              => 472.3894,
                        PARTNER_STAT_ID      => 0,
                        PARTNERWITHOUTNDS    => 400.33,
                        SHOWS                => 24,
                        TOTAL_BID_SUM        => 45.5,
                        TOTAL_RESPONSE_COUNT => 87,
                        CLIENT_ID            => 0,
                    },
                ];

                if ($opts{'_get_tsv_fh'}) {
                    foreach my $entry (@$struct) {
                        $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                    }
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return $struct;
                }
            } else {
                warn "You must run get_dsp_stat with option include_partner_stat_id";
                exit 1;
            }
        } else {
            if ($opts{'_get_tsv_fh'}) {
                open(my $fh, '<', \$tsv);
                return $fh;
            } else {
                return [];
            }
        }
    };

    local *{'QBit::Application::Model::API::Yandex::HTTPBK::get_dsp_page_stat'} = sub {
        my ($self, %opts) = @_;

        my @headers = qw(
          Date
          PageID
          ImpID
          DSPID
          WinHits
          WinPrice
          WinPartnerPrice
          Shows
          AllHits
          WinMaxPositionsCount
          AllRealPrice
          BadWinHits
          BadWinPrice
          BadWinPartnerPrice
          BadShows
          BadAllHits
          BadWinMaxPositionsCount
          BadAllRealPrice
          );

        my $tsv = join("\t", @headers) . "\n";

        if ($opts{starttime} eq $DATE) {
            my $struct = [
                {
                    AllHits            => 2559,
                    AllRealPrice       => 0,
                    BadAllHits         => 70,
                    BadAllRealPrice    => 0,
                    BadShows           => 0,
                    BadWinHits         => 70,
                    BadWinPartnerPrice => 0,
                    BadWinPrice        => 0,
                    Date               => $DATE,
                    DSPID              => 2563108,
                    ImpID              => 1,
                    PageID             => $PAGE_ID,
                    Shows              => 0,
                    WinHits            => 2559,
                    WinPartnerPrice    => 0,
                    WinPrice           => 0,
                },
            ];
            if ($opts{':return_fh'}) {
                foreach my $entry (@$struct) {
                    $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                }
                open(my $fh, '<', \$tsv);
                return $fh;
            } else {
                return $struct;
            }
        } else {
            if ($opts{':return_fh'}) {
                open(my $fh, '<', \$tsv);
                return $fh;
            } else {
                return [];
            }
        }
    };

    local *{'QBit::Application::Model::API::Yandex::HTTPBK::get_direct_rtb_stat'} = sub {
        my ($self, %opts) = @_;

        my @headers =
          qw(EventDate PageID ImpID PartnerStatID SumBannerShows SumBannerClicks SumBadBannerShows SumBadBannerClicks);

        my $tsv = join("\t", @headers) . "\n";

        if ($opts{date_from} eq $DATE) {
            my $struct = [
                {
                    EventDate          => $DATE,
                    PageID             => $PAGE_ID,
                    PartnerStatID      => 0,
                    SumBadBannerClicks => 6,
                    SumBadBannerShows  => 2086,
                    SumBannerClicks    => 44,
                    SumBannerShows     => 9741,
                    ImpID              => 1,
                },
            ];
            if ($opts{':return_fh'}) {
                foreach my $entry (@$struct) {
                    $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                }
                $tsv = '#' . $tsv . "#END\n";
                open(my $fh, '<', \$tsv);
                return $fh;
            } else {
                return $struct;
            }
        } else {
            if ($opts{':return_fh'}) {
                $tsv = '#' . $tsv . "#END\n";
                open(my $fh, '<', \$tsv);
                return $fh;
            } else {
                return [];
            }
        }
    };

    $app->statistics_advnet_context_on_site_rtb->regular_update_statistics(storage => 'clickhouse');

    return 1;
}

sub check_statistic_data_in_database {
    my ($app) = @_;

    my $statistics_context_on_site_rtb = $app->clickhouse_db->statistics->get_all(order_by => [qw(shows)]);

    is(scalar(@$statistics_context_on_site_rtb), 3, 'Table "statistics" has expected amount of rows',);

    my $expected = get_test_data_and_update_if_needed('statistics.json', $statistics_context_on_site_rtb);

    cmp_deeply($statistics_context_on_site_rtb, $expected, 'Got exepected data',);

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate("$DATE 00:00:00");
        add_data_to_database($app);

        update_statistics($app);

        check_statistic_data_in_database($app);

    },
    fill_databases       => 0,
    init                 => [qw(api_balance api_http_bk)],
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
);
