use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        my %get_statistics_arguments = (
            dimension_fields => [],
            entity_fields    => ["page_id"],
            fields           => [
                "outdoor_block_shows",       "outdoor_block_shows_own_adv",
                "outdoor_block_hits",        "outdoor_block_hits_own_adv",
                "outdoor_block_hits_unsold", "outdoor_all_w_nds",
                "outdoor_block_all_hits"
            ],
            levels => [{id => "outdoor_block",},],
            period => "today",
            total  => 0,
            vat    => 0,
        );

        my $_get_stat_from_balance_data = [
            {
                'outdoor_block_win_hits_unsold'        => 0,
                'outdoor_block_hits_unsold'            => 0,
                'outdoor_bad_win_partner_price_w_nds'  => 0,
                'dt'                                   => '2014-03-01',
                'outdoor_bad_win_partner_price_wo_nds' => 0,
                'outdoor_all_w_nds'                    => 0,
                'block_id'                             => 3,
                'outdoor_block_bad_win_hits_unsold'    => 0,
                'bad_win_partner_price_wo_nds'         => 0,
                'all_wo_nds'                           => 0,
                'bad_win_price_w_nds'                  => 0,
                'bad_win_partner_price_w_nds'          => 0,
                'outdoor_bad_win_price_w_nds'          => 0,
                'outdoor_partner_w_nds'                => 0,
                'outdoor_all_wo_nds'                   => 0,
                'all_w_nds'                            => 0,
                'currency_id'                          => 2,
                'outdoor_block_win_hits_own_adv'       => 0,
                'outdoor_block_hits_own_adv'           => 0,
                'dsp_id'                               => 1,
                'outdoor_partner_wo_nds'               => 0,
                'page_id'                              => 400,
                'outdoor_bad_win_price_wo_nds'         => 0,
                'partner_wo_nds'                       => 0,
                'bad_win_price_wo_nds'                 => 0,
                'outdoor_block_shows'                  => 0,
                'outdoor_block_bad_shows'              => 0,
                'outdoor_block_shows_own_adv'          => 0,
                'outdoor_block_bad_win_hits_own_adv'   => 0,
                'outdoor_block_bad_shows_own_adv'      => 0,
                'partner_w_nds'                        => 0,
                'outdoor_block_bad_win_hits'           => 0,
                'outdoor_block_win_hits'               => 15,
                'outdoor_block_hits'                   => 0,
                'tag_id'                               => 0,
                'outdoor_block_direct_clicks'          => 0,
                'outdoor_block_direct_shows'           => 0,
            },
            {
                'outdoor_block_win_hits_unsold'        => 0,
                'outdoor_block_hits_unsold'            => 0,
                'outdoor_bad_win_partner_price_w_nds'  => 0,
                'dt'                                   => '2014-03-01',
                'outdoor_bad_win_partner_price_wo_nds' => 0,
                'outdoor_all_w_nds'                    => '12344570000',
                'block_id'                             => '3',
                'outdoor_block_bad_win_hits_unsold'    => 0,
                'bad_win_partner_price_wo_nds'         => 0,
                'all_wo_nds'                           => '10461500000',
                'bad_win_price_w_nds'                  => 0,
                'bad_win_partner_price_w_nds'          => 0,
                'outdoor_bad_win_price_w_nds'          => 0,
                'outdoor_partner_w_nds'                => 6172285000,
                'outdoor_all_wo_nds'                   => '10461500000',
                'all_w_nds'                            => '12344570000',
                'currency_id'                          => 2,
                'outdoor_block_win_hits_own_adv'       => 0,
                'outdoor_block_hits_own_adv'           => 0,
                'dsp_id'                               => '1',
                'outdoor_partner_wo_nds'               => 5230750000,
                'page_id'                              => '400',
                'outdoor_bad_win_price_wo_nds'         => 0,
                'partner_wo_nds'                       => 5230750000,
                'bad_win_price_wo_nds'                 => 0,
                'outdoor_block_shows'                  => 12,
                'outdoor_block_bad_shows'              => 0,
                'outdoor_block_shows_own_adv'          => 0,
                'outdoor_block_bad_win_hits_own_adv'   => 0,
                'outdoor_block_bad_shows_own_adv'      => 0,
                'partner_w_nds'                        => 6172285000,
                'outdoor_block_bad_win_hits'           => 0,
                'outdoor_block_win_hits'               => 0,
                'outdoor_block_hits'                   => 14,
                'tag_id'                               => 100000,
                'outdoor_block_direct_clicks'          => 4,
                'outdoor_block_direct_shows'           => 8,
            }
        ];

        $app->api_balance->mock(
            'get_dsp_stat',
            sub {
                return [
                    {
                        'DSPWITHOUTNDS'        => '1.04615',
                        'BLOCK_ID'             => '3',
                        'AGGREGATORWITHOUTNDS' => '',
                        'TOTAL_BID_SUM'        => '0',
                        'DSP_ID'               => '1',
                        'SHOWS'                => '12',
                        'HITS'                 => '14',
                        'PAGE_ID'              => '400',
                        'DSP'                  => '1.234457',
                        'TOTAL_RESPONSE_COUNT' => '0',
                        'AGGREGATOR'           => '',
                        'PARTNERWITHOUTNDS'    => '0.523075',
                        'PARTNER'              => '0.6172285',
                        'DT'                   => '2014-03-01 00:00:00',
                        'PARTNER_STAT_ID'      => '100000',
                    }
                ];
            }
        );

        $app->api_http_bk->mock(
            'get_direct_rtb_stat',
            sub {
                return [
                    {
                        EventDate          => '2014-03-01',
                        PageID             => 400,
                        ImpID              => 3,
                        PartnerStatID      => '100000',
                        SumBannerShows     => 10,
                        SumBannerClicks    => 5,
                        SumBadBannerShows  => 2,
                        SumBadBannerClicks => 1
                    }
                ];
            }
        );

        $app->api_http_bk->mock(
            'get_dsp_page_stat',
            sub {
                return [
                    {
                        Date                 => '2014-03-01',
                        PageID               => 400,
                        ImpID                => 3,
                        DSPID                => 1,
                        BadShows             => 0,
                        BadWinHits           => 0,
                        BadWinPrice          => 0,
                        BadWinPartnerPrice   => 0,
                        WinMaxPositionsCount => 15,
                    }
                ];
            }
        );

        my $stat_from_balance = [
            sort {
                     $a->{'page_id'} <=> $b->{'page_id'}
                  || $a->{'block_id'} <=> $b->{'block_id'}
                  || $a->{'tag_id'} <=> $b->{'tag_id'}
              } @{
                $app->statistics_outdoor_block->_get_stat_from_balance(
                    map {
                        $_ => curdate(oformat => 'db')
                      } qw(from to)
                )
              }
        ];

        is_deeply($stat_from_balance, $_get_stat_from_balance_data, '_get_stat_from_balance is correct');

        $app->statistics_outdoor_block->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        my $stat =
          [sort {$a->{'page_id'} cmp $b->{'page_id'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
              @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

        my $update_statistics_data = [
            {
                'outdoor_block_shows'         => 12,
                'outdoor_block_hits_unsold'   => 1,
                'currency_id'                 => '2',
                'outdoor_block_hits_own_adv'  => 0,
                'outdoor_block_shows_own_adv' => 0,
                'outdoor_block_hits'          => 14,
                'outdoor_block_all_hits'      => 15,
                'outdoor_all_w_nds'           => '1.23',
                'page_id'                     => '400',
            }
        ];
        is_deeply($stat, $update_statistics_data, 'get_statistics is correct');
    },
    mock_http            => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
);
