#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Deep qw(cmp_deeply);

use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;

my $TESTS = [
    {
        name   => 'clickhouse return empty result',
        blocks => [],
    },
    {
        name   => 'clickhouse return blocks',
        blocks => [{page_id => 1, id => 1}, {page_id => 2, id => 1}, {page_id => 2, id => 2},],
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-07-25 17:30:45');

        my @SQL    = ();
        my $BLOCKS = [];
        my $PK     = [];

        my $RESET_IDS = {};

        mock_subs(
            {
                'QBit::Application::Model::DB::clickhouse::Query::get_all' => sub {

                    my ($sql) = $_[0]->get_sql_with_data();

                    push(@SQL, $sql);

                    return [
                        map {
                            {$PK->[0] => $_->{'page_id'}, $PK->[1] => $_->{'id'}}
                          } @$BLOCKS
                    ];
                },
                'QBit::Application::Model::DB::Query::get_all' => sub {
                    my ($sql) = $_[0]->get_sql_with_data();

                    push(@SQL, $sql);

                    my $has_active = $sql =~ m/active/;
                    my $is_block = @$PK == 2;

                    return $is_block
                      ? [
                        map {
                            {
                                $PK->[0]   => $_->{'page_id'},
                                  $PK->[1] => $_->{'id'},
                                  ($has_active ? (active => $_->{'page_id'} == 1 ? 0 : 1) : ())
                            }
                          } @$BLOCKS
                        ]
                      : array_uniq(
                        map {
                            $_->{'page_id'}
                          } @$BLOCKS
                      );    # fake id of a page = page_id
                },
                'Application::Model::Product::maybe_do_action' => sub {
                    push(@{$RESET_IDS->{$_[0]->accessor}}, $_[1]);

                    return TRUE;
                },
            }
        );

        my $stat_levels = $app->product_manager->get_statistics_products();

        foreach my $level (sort @$stat_levels) {
            next unless $app->$level->support_clickhouse;

            my $table = $app->$level->product->partner_db_table();
            $PK = $table->primary_key();

            foreach my $test (@$TESTS) {
                $BLOCKS = $test->{'blocks'};

                $app->$level->check_statistics_by_blocks();
            }
        }

        my $sql = join("\n\n", @SQL) . "\n";

        my $expected_sql = get_test_data_and_update_if_needed('data.sql', $sql, raw => TRUE);

        eq_or_diff($sql, $expected_sql, 'Correct sql');

        my $expected_reset_ids = get_test_data_and_update_if_needed('reset_ids.json', $RESET_IDS);

        cmp_deeply($RESET_IDS, $expected_reset_ids, 'Correct reset ids');
    },
    fill_databases => FALSE,
    init           => [qw(clickhouse_db)],
);
