#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::More;

use qbit;

require Application::Model::Statistics::Product;

my %cases = (
    increase => {
        args => {
            page_stat   => [{shows => 100}],
            blocks_stat => [{shows => 10}, {shows => 20}, {shows => 30},],
            opts        => {fields => [qw(shows)],},
        },
        return_value => [{shows => 17}, {shows => 33}, {shows => 50},]
    },
    decrease => {
        args => {
            page_stat   => [{shows => 131}],
            blocks_stat => [{shows => 73}, {shows => 59}, {shows => 67},],
            opts        => {fields => [qw(shows)],},
        },
        return_value => [{shows => 48}, {shows => 39}, {shows => 44},]
    },
    multiple_fields => {
        args => {
            page_stat   => [{shows => 163, clicks => 163}],
            blocks_stat => [{shows => 191, clicks => 191}],
            opts        => {fields => [qw(shows clicks)],},
        },
        return_value => [{shows => 163, clicks => 163}]
    },
    dump_the_rest => {
        args => {
            page_stat => [{shows => 149}],
            blocks_stat => [map    {{shows => 149}} 1 .. 100],
            opts        => {fields => [qw(shows)],},
        },
        return_value =>
          [(({shows => 1}, {shows => 2}) x 25), {shows => 1}, (({shows => 1}, {shows => 2}) x 24), {shows => 1}]
    },
    zero_the_rest => {
        args => {
            page_stat => [{shows => 150}],
            blocks_stat => [map    {{shows => 150}} 1 .. 100],
            opts        => {fields => [qw(shows)],},
        },
        return_value => [(({shows => 2}, {shows => 1}) x 50)]
    },
    very_different_values => {
        args => {
            page_stat   => [{shows => 1000}],
            blocks_stat => [
                (map {{shows => 2}} 1 .. 30),
                (map {{shows => 100}} 1 .. 5),
                (map {{shows => 1}} 1 .. 30),
                (map {{shows => 150}} 1 .. 3),
                (map {{shows => 2}} 1 .. 30)
            ],
            opts => {fields => [qw(shows)],},
        },
        return_value => from_json(readfile(lib::abs::path('./fix_statistics/data.json')))
    },
);

run_tests(
    sub {
        my ($app) = @_;

        for my $name (sort keys %cases) {
            my $case = $cases{$name};

            is_deeply(
                Application::Model::Statistics::Product::fix_statistics(
                    undef,
                    $case->{args}{page_stat},
                    $case->{args}{blocks_stat},
                    %{$case->{args}{opts}},
                ),
                $case->{return_value},
                $name
            );
        }
    },
    dont_create_database => TRUE,
);
