#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

my $FIXTURES = [
    {
        name        => 'get_product_ids without fields (returns page and child levels)',
        level       => 'statistics_video_an_site',
        args        => {},
        product_ids => ['video_an_site', 'video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen']
    },
    {
        name        => 'get_product_ids with fields from page level only (returns page level)',
        level       => 'statistics_video_an_site',
        args        => {fields => {instream_block_open_player => {}}},
        product_ids => ['video_an_site']
    },
    {
        name =>
'get_product_ids with fields from page level only but depends on fields from child levels (returns page and child levels)',
        level => 'statistics_video_an_site',
        args  => {fields => {instream_block_pauseroll_shows => {}}},
        product_ids => ['video_an_site', 'video_an_site_instream']
    },
    {
        name        => 'get_product_ids with fields from child levels only (returns child levels)',
        level       => 'statistics_video_an_site',
        args        => {fields => {instream_block_shows => {}}},
        product_ids => ['video_an_site_instream']
    },
    {
        name  => 'get_product_ids with fields from page and child levels (returns page and child levels)',
        level => 'statistics_video_an_site',
        args  => {fields => {instream_block_open_player => {}, instream_block_shows => {}}},
        product_ids => ['video_an_site', 'video_an_site_instream']
    },
];

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test (@$FIXTURES) {
            my ($name, $level, $args, $product_ids) = @$test{qw(name level args product_ids)};

            eq_or_diff($app->$level->get_product_ids(%$args), $product_ids, $name);
        }
    },
    dont_create_database => TRUE,
);
