#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Differences qw(eq_or_diff);
use Capture::Tiny qw( capture_stderr );

use qbit;
use PiConstants qw( $STAT_MONEY_SCALE );

require Application::Model::Statistics::Product;

run_tests(
    sub {
        my ($app) = @_;

        my $diff_fields_format = [
            ['partner_wo_nds', '%14.6f'],
            ['partner_w_nds',  '%14.6f'],
            ['all_w_nds',      '%14.6f'],
            ['clicks',         '%14d'],
            ['shows',          '%14d']
        ];

        my $sums = {
            partner_wo_nds => 1 * $STAT_MONEY_SCALE,
            partner_w_nds  => 1 * $STAT_MONEY_SCALE,
            all_w_nds      => 0.75 * $STAT_MONEY_SCALE,
            clicks         => 100,
            shows          => 1,
        };

        my $page_stat = {
            partner_wo_nds => 0,
            partner_w_nds  => undef,
            all_w_nds      => 1 * $STAT_MONEY_SCALE,
            clicks         => 75,
            shows          => 1,
        };
        my $got = '';
        {
            no strict 'refs';
            no warnings 'redefine';
            *{'Application::Model::Statistics::Product::WARN'} = sub {
                $got = shift;
              }
        }
        Application::Model::Statistics::Product::print_diff($app->statistics_advnet_context_on_site_direct,
            '2017-06-20', 77777, $sums, $page_stat, $diff_fields_format);

        my $expect = q[
FIX STATISTICS!!!
Level: statistics_advnet_context_on_site_direct
Date: 2017-06-20
Page ID: 77777

 -                   pages          tags         diff, %
--------------------------------------------------------
partner_wo_nds        0.000000       1.000000    0.0000
partner_w_nds         0.000000       1.000000    0.0000
all_w_nds             1.000000       0.750000  -25.0000
clicks                      75            100   33.3333
];

        Test::Differences::eq_or_diff($got, $expect, 'diff');
    },
    dont_create_database => 1,
);
