use Test::Most;

require Application::Model::Statistics::Fields::Metrics;
use Test::Partner2::Simple;

my @tests = (
    {
        args   => [1, 1],
        answer => '1',
    },
    {
        args   => [1, 2],
        answer => '0.5',
    },
    {
        args   => [1, 10],
        answer => '0.1',
    },
    {
        args   => [],
        answer => '-',
    },
    {
        args   => [1],
        answer => '-',
    },
    {
        args   => [1, 0],
        answer => '-',
    },
);

foreach my $t (@tests) {
    is(
        Application::Model::Statistics::Fields::Metrics::safe_div($t->{'args'}[0], $t->{'args'}[1]),
        $t->{'answer'}, "safe_div(@{$t->{'args'}}) == $t->{'answer'}",
      );
}

done_testing();
