#!/usr/bin/perl

use Test::Partner2::Simple;
use qbit;

use Test::Deep qw(cmp_deeply);
use Test::Partner2::Mock qw(mock_curdate);

my $DATE = '2018-05-11 12:34:27';

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($DATE);

        my $id = $app->stat_report_params_digest->add(params => '{}');

        cmp_deeply(
            $app->stat_report_params_digest->get($id, fields => ['*']),
            {
                id          => 'bf21a9e8fbc5a3846fb05b4fa0859e0917b2202f',
                params      => '{}',
                update_date => $DATE,
            },
            'get'
        );
    },
);
