#!/usr/bin/perl

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use qbit;

use Test::Deep qw(cmp_bag);

my @fixtures = qw(stat_report_params_digest_to_clean stat_report_params_digest_new);

run_tests(
    sub {
        my ($app, %opts) = @_;

        my $reports = get_fixtures_hash(@fixtures);

        cmp_bag($app->stat_report_params_digest->get_all(fields => ['id']), [values(%$reports)], 'before clean');

        $app->stat_report_params_digest->clean();

        cmp_bag(
            $app->stat_report_params_digest->get_all(fields => ['id']),
            [$reports->{'stat_report_params_digest_new'}],
            'after clean'
        );
    },
    fixtures       => \@fixtures,
    fill_databases => FALSE,
);
