#!/usr/bin/perl

use Test::Partner2::Simple;
use Test::Partner2::Fixture;
use qbit;

use Test::More;
use Test::Partner2::Mock qw(mock_curdate);

my $DATE = '2018-12-20 12:34:27';

run_tests(
    sub {
        my ($app, %opts) = @_;

        my $report_id = get_fixture('stat_report_params_digest_to_clean');

        is(
            $app->stat_report_params_digest->get($report_id, fields => ['update_date'])->{'update_date'},
            '2018-09-23 12:56:34',
            'before update'
          );

        mock_curdate($DATE);

        $app->stat_report_params_digest->update($report_id);

        is($app->stat_report_params_digest->get($report_id, fields => ['update_date'])->{'update_date'},
            $DATE, 'after update');
    },
    fixtures       => [qw(stat_report_params_digest_to_clean)],
    fill_databases => FALSE,
);
